/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cuchaz.ships.EntityShip;
import java.util.List;
import net.minecraft.client.settings.GameSettings;
import org.lwjgl.input.Keyboard;

public enum PilotAction {
    Forward{

        @Override
        public void applyToShip(EntityShip ship) {
            ship.linearThrottle = 100;
        }

        @Override
        public void resetShip(EntityShip ship) {
            ship.linearThrottle = 0;
        }
    }
    ,
    Backward{

        @Override
        public void applyToShip(EntityShip ship) {
            ship.linearThrottle = -25;
        }

        @Override
        public void resetShip(EntityShip ship) {
            ship.linearThrottle = 0;
        }
    }
    ,
    Left{

        @Override
        public void applyToShip(EntityShip ship) {
            ship.angularThrottle = 1;
        }

        @Override
        public void resetShip(EntityShip ship) {
            ship.angularThrottle = 0;
        }
    }
    ,
    Right{

        @Override
        public void applyToShip(EntityShip ship) {
            ship.angularThrottle = -1;
        }

        @Override
        public void resetShip(EntityShip ship) {
            ship.angularThrottle = 0;
        }
    }
    ,
    ThrottleUp{
        private boolean m_isForwardAllowed = true;

        @Override
        public void applyToShip(EntityShip ship) {
            if (ship.linearThrottle < 0) {
                this.m_isForwardAllowed = false;
            }
            if (ship.linearThrottle < 0 || ship.linearThrottle == 0 && this.m_isForwardAllowed || ship.linearThrottle > 0) {
                ship.linearThrottle = ship.linearThrottle < 0 && ship.linearThrottle > -2 ? 0 : (ship.linearThrottle += 2);
            }
        }

        @Override
        public void resetShip(EntityShip ship) {
            this.m_isForwardAllowed = true;
        }
    }
    ,
    ThrottleDown{
        private boolean m_isReverseAllowed = true;

        @Override
        public void applyToShip(EntityShip ship) {
            if (ship.linearThrottle > 0) {
                this.m_isReverseAllowed = false;
            }
            if (ship.linearThrottle > 0 || ship.linearThrottle == 0 && this.m_isReverseAllowed || ship.linearThrottle < 0) {
                ship.linearThrottle = ship.linearThrottle > 0 && ship.linearThrottle < 2 ? 0 : (ship.linearThrottle -= 2);
            }
        }

        @Override
        public void resetShip(EntityShip ship) {
            this.m_isReverseAllowed = true;
        }
    };

    private int m_keyCode = -1;

    private PilotAction() {
    }

    public static void setActionCodes(GameSettings settings) {
        PilotAction.Forward.m_keyCode = settings.field_74351_w.field_74512_d;
        PilotAction.Backward.m_keyCode = settings.field_74368_y.field_74512_d;
        PilotAction.Left.m_keyCode = settings.field_74370_x.field_74512_d;
        PilotAction.Right.m_keyCode = settings.field_74366_z.field_74512_d;
        PilotAction.ThrottleUp.m_keyCode = settings.field_74351_w.field_74512_d;
        PilotAction.ThrottleDown.m_keyCode = settings.field_74368_y.field_74512_d;
    }

    public static int getActiveActions(GameSettings settings, List<PilotAction> allowedActions) {
        int actions = 0;
        for (PilotAction action : allowedActions) {
            if (!Keyboard.isKeyDown((int)action.m_keyCode)) continue;
            actions |= 1 << action.ordinal();
        }
        return actions;
    }

    public static void applyToShip(EntityShip ship, int actions) {
        PilotAction[] pilotActionArray = PilotAction.values();
        int n = pilotActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            PilotAction action = pilotActionArray[n2];
            if (action.isActive(actions)) {
                action.applyToShip(ship);
            }
            ++n2;
        }
    }

    public static void resetShip(EntityShip ship, int actions, int oldActions) {
        PilotAction[] pilotActionArray = PilotAction.values();
        int n = pilotActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            PilotAction action = pilotActionArray[n2];
            if (action.isActive(oldActions) && !action.isActive(actions)) {
                action.resetShip(ship);
            }
            ++n2;
        }
    }

    public boolean isActive(int actions) {
        return (actions >> this.ordinal() & 1) == 1;
    }

    protected abstract void applyToShip(EntityShip var1);

    protected void resetShip(EntityShip ship) {
    }

    /* synthetic */ PilotAction(String string, int n, PilotAction pilotAction) {
        this();
    }
}

