/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cuchaz.modsShared.BlockSide;
import cuchaz.modsShared.BoxCorner;
import cuchaz.modsShared.RotatedBB;
import cuchaz.ships.EntityShip;
import cuchaz.ships.ShipWorld;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAccessor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ShipCollider {
    private EntityShip m_ship;
    public List<ChunkCoordinates> m_highlightedCoords = new ArrayList<ChunkCoordinates>();
    public AxisAlignedBB m_queryBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);

    public ShipCollider(EntityShip ship) {
        this.m_ship = ship;
    }

    public void computeShipBoundingBox(AxisAlignedBB box, double x, double y, double z, float yaw) {
        ShipWorld blocks = this.m_ship.getBlocks();
        if (blocks == null) {
            return;
        }
        box.field_72340_a = x + this.m_ship.blocksToShipX(blocks.getBoundingBox().minX);
        box.field_72338_b = y + this.m_ship.blocksToShipY(blocks.getBoundingBox().minY);
        box.field_72339_c = z + this.m_ship.blocksToShipZ(blocks.getBoundingBox().minZ);
        box.field_72336_d = x + this.m_ship.blocksToShipX(blocks.getBoundingBox().maxX + 1);
        box.field_72337_e = y + this.m_ship.blocksToShipY(blocks.getBoundingBox().maxY + 1);
        box.field_72334_f = z + this.m_ship.blocksToShipZ(blocks.getBoundingBox().maxZ + 1);
        RotatedBB rotatedBox = new RotatedBB(box.func_72329_c(), yaw, x, z);
        box.field_72340_a = 2.147483647E9;
        box.field_72336_d = -2.147483648E9;
        box.field_72339_c = 2.147483647E9;
        box.field_72334_f = -2.147483648E9;
        Vec3 p = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        BoxCorner[] boxCornerArray = BlockSide.Top.getCorners();
        int n = boxCornerArray.length;
        int n2 = 0;
        while (n2 < n) {
            BoxCorner corner = boxCornerArray[n2];
            rotatedBox.getCorner(p, corner);
            box.field_72340_a = Math.min(box.field_72340_a, p.field_72450_a);
            box.field_72336_d = Math.max(box.field_72336_d, p.field_72450_a);
            box.field_72339_c = Math.min(box.field_72339_c, p.field_72449_c);
            box.field_72334_f = Math.max(box.field_72334_f, p.field_72449_c);
            ++n2;
        }
    }

    public TreeSet<MovingObjectPosition> getBlocksPlayerIsLookingAt(EntityPlayer player) {
        Vec3 eyePos = player.field_70170_p.func_82732_R().func_72345_a(player.field_70165_t, player.field_70163_u + (double)player.field_70139_V - (double)player.field_70129_M + (double)player.func_70047_e(), player.field_70161_v);
        double toRadians = Math.PI / 180;
        float pitch = (float)((double)player.field_70125_A * (Math.PI / 180));
        float yaw = (float)((double)player.field_70177_z * (Math.PI / 180));
        float cosYaw = MathHelper.func_76134_b((float)(-yaw - (float)Math.PI));
        float sinYaw = MathHelper.func_76126_a((float)(-yaw - (float)Math.PI));
        float cosPitch = MathHelper.func_76134_b((float)(-pitch));
        float sinPitch = MathHelper.func_76126_a((float)(-pitch));
        double dist = 5.0;
        Vec3 targetPos = eyePos.func_72441_c((double)(sinYaw * -cosPitch) * dist, (double)sinPitch * dist, (double)(cosYaw * -cosPitch) * dist);
        this.m_ship.worldToShip(eyePos);
        this.m_ship.worldToShip(targetPos);
        this.m_ship.shipToBlocks(eyePos);
        this.m_ship.shipToBlocks(targetPos);
        return this.lineSegmentQuery(eyePos, targetPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNearbyEntityMoved(double oldX, double oldY, double oldZ, double oldYSize, Entity entity) {
        AxisAlignedBB oldEntityBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        this.getEntityBoxInBlockSpace(oldEntityBox, entity, Vec3.func_72443_a((double)oldX, (double)oldY, (double)oldZ));
        AxisAlignedBB newEntityBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        this.getEntityBoxInBlockSpace(newEntityBox, entity);
        double dYSize = (double)entity.field_70139_V - oldYSize;
        oldEntityBox.field_72337_e -= dYSize;
        oldEntityBox.field_72338_b -= dYSize;
        if (entity instanceof EntityPlayer) {
            this.m_queryBox.func_72328_c(oldEntityBox);
        }
        List<PossibleCollision> possibleCollisions = this.trajectoryQuery(oldEntityBox, newEntityBox);
        double originalDx = newEntityBox.field_72340_a - oldEntityBox.field_72340_a;
        double originalDy = newEntityBox.field_72338_b - oldEntityBox.field_72338_b;
        double originalDz = newEntityBox.field_72339_c - oldEntityBox.field_72339_c;
        if (entity instanceof EntityPlayer) {
            List<ChunkCoordinates> list = this.m_highlightedCoords;
            synchronized (list) {
                this.m_highlightedCoords.clear();
                for (PossibleCollision collision : possibleCollisions) {
                    this.m_highlightedCoords.add(collision.coords);
                }
            }
        }
        if (possibleCollisions.isEmpty()) {
            return;
        }
        double dy = originalDy;
        for (PossibleCollision collision : possibleCollisions) {
            dy = collision.box.func_72323_b(oldEntityBox, dy);
        }
        dy = this.applyBackoff(dy, originalDy);
        oldEntityBox.func_72317_d(0.0, dy, 0.0);
        double dx = originalDx;
        for (PossibleCollision collision : possibleCollisions) {
            dx = collision.box.func_72316_a(oldEntityBox, dx);
        }
        dx = this.applyBackoff(dx, originalDx);
        oldEntityBox.func_72317_d(dx, 0.0, 0.0);
        double dz = originalDz;
        for (PossibleCollision collision : possibleCollisions) {
            dz = collision.box.func_72322_c(oldEntityBox, dz);
        }
        dz = this.applyBackoff(dz, originalDz);
        oldEntityBox.func_72317_d(0.0, 0.0, dz);
        Vec3 newPos = Vec3.func_72443_a((double)((oldEntityBox.field_72340_a + oldEntityBox.field_72336_d) / 2.0), (double)oldEntityBox.field_72338_b, (double)((oldEntityBox.field_72339_c + oldEntityBox.field_72334_f) / 2.0));
        this.m_ship.blocksToShip(newPos);
        this.m_ship.shipToWorld(newPos);
        entity.func_70107_b(newPos.field_72450_a, newPos.field_72448_b + (double)entity.field_70129_M - (double)entity.field_70139_V, newPos.field_72449_c);
        entity.field_70123_F = originalDx != dx || originalDz != dz;
        entity.field_70124_G = originalDy != dy;
        entity.field_70122_E = entity.field_70124_G && originalDy < 0.0;
        boolean bl = entity.field_70132_H = entity.field_70123_F || entity.field_70124_G;
        if (originalDx != dx) {
            entity.field_70159_w = 0.0;
        }
        if (originalDy != dy) {
            entity.field_70181_x = 0.0;
        }
        if (originalDz != dz) {
            entity.field_70179_y = 0.0;
        }
        EntityAccessor.updateFallState(entity, dy, entity.field_70122_E);
    }

    public AxisAlignedBB getBlockBoxInBlockSpace(ChunkCoordinates coords) {
        Block block = Block.field_71973_m[this.m_ship.getBlocks().getBlockId(coords)];
        block.func_71902_a((IBlockAccess)this.m_ship.getBlocks(), coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
        return AxisAlignedBB.func_72330_a((double)(block.func_83009_v() + (double)coords.field_71574_a), (double)(block.func_83008_x() + (double)coords.field_71572_b), (double)(block.func_83005_z() + (double)coords.field_71573_c), (double)(block.func_83007_w() + (double)coords.field_71574_a), (double)(block.func_83010_y() + (double)coords.field_71572_b), (double)(block.func_83006_A() + (double)coords.field_71573_c));
    }

    public RotatedBB getBlockBoxInWorldSpace(ChunkCoordinates coords) {
        return this.m_ship.blocksToWorld(this.getBlockBoxInBlockSpace(coords));
    }

    public AxisAlignedBB getBlockWorldBoundingBox(AxisAlignedBB box, ChunkCoordinates coords) {
        Vec3 p = Vec3.func_72443_a((double)((double)coords.field_71574_a + 0.5), (double)((double)coords.field_71572_b + 0.5), (double)((double)coords.field_71573_c + 0.5));
        this.m_ship.blocksToShip(p);
        this.m_ship.shipToWorld(p);
        float yawRad = (float)Math.toRadians(this.m_ship.field_70177_z);
        double cos = MathHelper.func_76134_b((float)yawRad);
        double sin = MathHelper.func_76126_a((float)yawRad);
        double halfSize = Math.max(Math.abs(cos - sin), Math.abs(sin + cos)) / 2.0;
        return box.func_72324_b(p.field_72450_a - halfSize, p.field_72448_b - 0.5, p.field_72449_c - halfSize, p.field_72450_a + halfSize, p.field_72448_b + 0.5, p.field_72449_c + halfSize);
    }

    public AxisAlignedBB getBlockWorldBoundingBox(AxisAlignedBB box, ChunkCoordinates coords, double shipX, double shipY, double shipZ, float shipYaw) {
        double oldX = this.m_ship.field_70165_t;
        double oldY = this.m_ship.field_70163_u;
        double oldZ = this.m_ship.field_70161_v;
        float oldYaw = this.m_ship.field_70177_z;
        this.m_ship.field_70165_t = shipX;
        this.m_ship.field_70163_u = shipY;
        this.m_ship.field_70161_v = shipZ;
        this.m_ship.field_70177_z = shipYaw;
        AxisAlignedBB blockWorldBox = this.getBlockWorldBoundingBox(box, coords);
        this.m_ship.field_70165_t = oldX;
        this.m_ship.field_70163_u = oldY;
        this.m_ship.field_70161_v = oldZ;
        this.m_ship.field_70177_z = oldYaw;
        return blockWorldBox;
    }

    public void moveShip(double dx, double dy, double dz, float dYaw) {
        double scaling = 1.0;
        int numCollidingBoxes = 0;
        BlockCollisionResult collisionResult = new BlockCollisionResult();
        for (ChunkCoordinates coords : this.m_ship.getBlocks().coords()) {
            this.checkBlockCollision(collisionResult, coords, dx, dy, dz, dYaw);
            if (collisionResult.scaling < 1.0) {
                scaling = Math.min(scaling, collisionResult.scaling);
            }
            numCollidingBoxes += collisionResult.numCollidingBoxes;
        }
        dx *= scaling;
        dy *= scaling;
        dz *= scaling;
        if (numCollidingBoxes > 0) {
            dYaw = 0.0f;
        }
        this.m_ship.field_70177_z += dYaw;
        this.m_ship.func_70107_b(this.m_ship.field_70165_t + dx, this.m_ship.field_70163_u + dy, this.m_ship.field_70161_v + dz);
    }

    public List<Entity> getRiders() {
        AxisAlignedBB checkBox = this.m_ship.field_70121_D.func_72329_c();
        checkBox.func_72314_b(1.0, 1.0, 1.0);
        List entities = this.m_ship.field_70170_p.func_72872_a(Entity.class, checkBox);
        Iterator iter = entities.iterator();
        while (iter.hasNext()) {
            Entity entity = (Entity)iter.next();
            if (entity != this.m_ship && this.isEntityAboard(entity)) continue;
            iter.remove();
        }
        return entities;
    }

    public boolean isEntityAboard(Entity entity) {
        if (!entity.field_70122_E) {
            return false;
        }
        double RiderEpsilon = 0.1;
        double entityMinY = this.m_ship.shipToBlocksY(this.m_ship.worldToShipY(entity.field_70121_D.field_72338_b));
        int blockY = (int)(entityMinY + 0.5) - 1;
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        this.getEntityBoxInBlockSpace(box, entity);
        for (ChunkCoordinates coords : this.m_ship.getBlocks().getGeometry().rangeQuery(box, blockY)) {
            boolean isOnBlock;
            boolean bl = isOnBlock = Math.abs((double)(coords.field_71572_b + 1) - box.field_72338_b) <= 0.1;
            if (!isOnBlock) continue;
            return true;
        }
        return false;
    }

    private void checkBlockCollision(BlockCollisionResult result, ChunkCoordinates coords, double dx, double dy, double dz, float dYaw) {
        AxisAlignedBB shipBlockBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        this.getBlockWorldBoundingBox(shipBlockBox, coords);
        double nextX = this.m_ship.field_70165_t + dx;
        double nextY = this.m_ship.field_70163_u + dy;
        double nextZ = this.m_ship.field_70161_v + dz;
        float nextYaw = this.m_ship.field_70177_z + dYaw;
        AxisAlignedBB nextShipBlockBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        this.getBlockWorldBoundingBox(nextShipBlockBox, coords, nextX, nextY, nextZ, nextYaw);
        AxisAlignedBB combinedBlockBox = shipBlockBox.func_111270_a(nextShipBlockBox);
        ArrayList nearbyWorldBlocks = new ArrayList();
        int minX = MathHelper.func_76128_c((double)combinedBlockBox.field_72340_a);
        int maxX = MathHelper.func_76128_c((double)combinedBlockBox.field_72336_d);
        int minY = MathHelper.func_76128_c((double)combinedBlockBox.field_72338_b);
        int maxY = MathHelper.func_76128_c((double)combinedBlockBox.field_72337_e);
        int minZ = MathHelper.func_76128_c((double)combinedBlockBox.field_72339_c);
        int maxZ = MathHelper.func_76128_c((double)combinedBlockBox.field_72334_f);
        int x = minX;
        while (x <= maxX) {
            int z = minZ;
            while (z <= maxZ) {
                int y = minY;
                while (y <= maxY) {
                    Block block = Block.field_71973_m[this.m_ship.field_70170_p.func_72798_a(x, y, z)];
                    if (block != null) {
                        block.func_71871_a(this.m_ship.field_70170_p, x, y, z, combinedBlockBox, nearbyWorldBlocks, null);
                    }
                    ++y;
                }
                ++z;
            }
            ++x;
        }
        result.scaling = 1.0;
        for (AxisAlignedBB worldBlockBox : nearbyWorldBlocks) {
            result.scaling = Math.min(result.scaling, this.getScalingToAvoidCollision(shipBlockBox, dx, dy, dz, worldBlockBox));
        }
        result.numCollidingBoxes = nearbyWorldBlocks.size();
    }

    private double getScalingToAvoidCollision(AxisAlignedBB box, double dx, double dy, double dz, AxisAlignedBB obstacleBox) {
        double sx = this.getScalingToAvoidCollision(dx, box.field_72340_a, box.field_72336_d, obstacleBox.field_72340_a, obstacleBox.field_72336_d);
        double sy = this.getScalingToAvoidCollision(dy, box.field_72338_b, box.field_72337_e, obstacleBox.field_72338_b, obstacleBox.field_72337_e);
        double sz = this.getScalingToAvoidCollision(dz, box.field_72339_c, box.field_72334_f, obstacleBox.field_72339_c, obstacleBox.field_72334_f);
        return Math.min(sx, Math.min(sy, sz));
    }

    private double getScalingToAvoidCollision(double delta, double selfMin, double selfMax, double obstacleMin, double obstacleMax) {
        double dist;
        double scaling = 1.0;
        if (delta > 0.0) {
            double dist2 = obstacleMin - selfMax;
            if (dist2 >= 0.0) {
                return dist2 / delta;
            }
        } else if (delta < 0.0 && (dist = selfMin - obstacleMax) >= 0.0) {
            return dist / -delta;
        }
        assert (scaling >= 0.0);
        return scaling;
    }

    private double applyBackoff(double d, double originalD) {
        double Backoff = 0.001;
        if (d != originalD) {
            if (d > 0.0) {
                return d - 0.001;
            }
            return d + 0.001;
        }
        return d;
    }

    private List<PossibleCollision> trajectoryQuery(AxisAlignedBB oldBox, AxisAlignedBB newBox) {
        AxisAlignedBB trajectoryBox = oldBox.func_111270_a(newBox);
        ArrayList<PossibleCollision> collisions = new ArrayList<PossibleCollision>();
        for (ChunkCoordinates coords : this.m_ship.getBlocks().getGeometry().rangeQuery(trajectoryBox)) {
            Block block = Block.field_71973_m[this.m_ship.getBlocks().getBlockId(coords)];
            block.func_71902_a((IBlockAccess)this.m_ship.getBlocks(), coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
            collisions.add(new PossibleCollision(coords, AxisAlignedBB.func_72330_a((double)(block.func_83009_v() + (double)coords.field_71574_a), (double)(block.func_83008_x() + (double)coords.field_71572_b), (double)(block.func_83005_z() + (double)coords.field_71573_c), (double)(block.func_83007_w() + (double)coords.field_71574_a), (double)(block.func_83010_y() + (double)coords.field_71572_b), (double)(block.func_83006_A() + (double)coords.field_71573_c))));
        }
        return collisions;
    }

    private void getEntityBoxInBlockSpace(AxisAlignedBB box, Entity entity) {
        this.getEntityBoxInBlockSpace(box, entity, Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v));
    }

    private void getEntityBoxInBlockSpace(AxisAlignedBB box, Entity entity, Vec3 pos) {
        pos = Vec3.func_72443_a((double)pos.field_72450_a, (double)pos.field_72448_b, (double)pos.field_72449_c);
        this.m_ship.worldToShip(pos);
        this.m_ship.shipToBlocks(pos);
        box.func_72328_c(entity.field_70121_D);
        box.func_72317_d(-entity.field_70165_t, -entity.field_70163_u, -entity.field_70161_v);
        box.func_72317_d(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }

    private TreeSet<MovingObjectPosition> lineSegmentQuery(final Vec3 from, Vec3 to) {
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)Math.min(from.field_72450_a, to.field_72450_a), (double)Math.min(from.field_72448_b, to.field_72448_b), (double)Math.min(from.field_72449_c, to.field_72449_c), (double)Math.max(from.field_72450_a, to.field_72450_a), (double)Math.max(from.field_72448_b, to.field_72448_b), (double)Math.max(from.field_72449_c, to.field_72449_c));
        List<ChunkCoordinates> nearbyBlocks = this.m_ship.getBlocks().getGeometry().rangeQuery(box);
        TreeSet<MovingObjectPosition> sortedIntersections = new TreeSet<MovingObjectPosition>(new Comparator<MovingObjectPosition>(){

            @Override
            public int compare(MovingObjectPosition a, MovingObjectPosition b) {
                return Double.compare(a.field_72307_f.func_72438_d(from), b.field_72307_f.func_72438_d(from));
            }
        });
        for (ChunkCoordinates coords : nearbyBlocks) {
            Block block = Block.field_71973_m[this.m_ship.getBlocks().getBlockId(coords)];
            MovingObjectPosition intersection = block.func_71878_a((World)this.m_ship.getBlocks(), coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, from, to);
            if (intersection == null) continue;
            sortedIntersections.add(intersection);
        }
        return sortedIntersections;
    }

    private static class BlockCollisionResult {
        public double scaling;
        public int numCollidingBoxes;

        private BlockCollisionResult() {
        }
    }

    private static class PossibleCollision {
        public ChunkCoordinates coords;
        public AxisAlignedBB box;

        public PossibleCollision(ChunkCoordinates coords, AxisAlignedBB box) {
            this.coords = coords;
            this.box = box;
        }
    }
}

