/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cuchaz.modsShared.BlockSide;
import cuchaz.modsShared.BlockUtils;
import cuchaz.modsShared.BoundingBoxInt;
import cuchaz.modsShared.BoxCorner;
import cuchaz.modsShared.Envelopes;
import cuchaz.modsShared.RotatedBB;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;

public class ShipGeometry {
    public static final BlockUtils.Neighbors ShipBlockNeighbors = BlockUtils.Neighbors.Edges;
    public static final BlockUtils.Neighbors VoidBlockNeighbors = BlockUtils.Neighbors.Faces;
    private TreeSet<ChunkCoordinates> m_blocks;
    private Envelopes m_envelopes;
    private List<TreeSet<ChunkCoordinates>> m_outerBoundaries;
    private List<TreeSet<ChunkCoordinates>> m_holes;
    private TreeMap<Integer, TreeSet<ChunkCoordinates>> m_trappedAir;

    public ShipGeometry(Set<ChunkCoordinates> blocks) {
        this.m_blocks = new TreeSet<ChunkCoordinates>(blocks);
        this.m_envelopes = new Envelopes(this.m_blocks);
        this.m_outerBoundaries = null;
        this.m_holes = null;
        this.m_trappedAir = null;
        this.computeBoundaryAndHoles();
        this.computeTrappedAir();
    }

    public Envelopes getEnvelopes() {
        return this.m_envelopes;
    }

    public List<TreeSet<ChunkCoordinates>> getOuterBoundaries() {
        return this.m_outerBoundaries;
    }

    public List<TreeSet<ChunkCoordinates>> getHoles() {
        return this.m_holes;
    }

    public TreeSet<ChunkCoordinates> getTrappedAir(int y) {
        TreeSet<Object> coords = this.m_trappedAir.get(y = Math.min(y, this.m_trappedAir.lastKey()));
        if (coords == null) {
            coords = new TreeSet();
        }
        return coords;
    }

    public List<ChunkCoordinates> rangeQuery(RotatedBB box) {
        int minY = MathHelper.func_76128_c((double)box.getMinY());
        int maxY = MathHelper.func_76128_c((double)box.getMaxY());
        ArrayList<ChunkCoordinates> blocks = new ArrayList<ChunkCoordinates>();
        int y = minY;
        while (y <= maxY) {
            blocks.addAll(this.xzRangeQuery(y, box));
            ++y;
        }
        return blocks;
    }

    public List<ChunkCoordinates> xzRangeQuery(int y, RotatedBB box) {
        Vec3 p = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        BoxCorner[] boxCornerArray = BlockSide.Top.getCorners();
        int n = boxCornerArray.length;
        int n2 = 0;
        while (n2 < n) {
            BoxCorner corner = boxCornerArray[n2];
            box.getCorner(p, corner);
            int x = MathHelper.func_76128_c((double)p.field_72450_a);
            int z = MathHelper.func_76128_c((double)p.field_72449_c);
            minX = Math.min(minX, x);
            maxX = Math.max(maxX, x);
            minZ = Math.min(minZ, z);
            maxZ = Math.max(maxZ, z);
            ++n2;
        }
        ChunkCoordinates coords = new ChunkCoordinates();
        ArrayList<ChunkCoordinates> blocks = new ArrayList<ChunkCoordinates>();
        int x = minX;
        while (x <= maxX) {
            int z = minZ;
            while (z <= maxZ) {
                coords.func_71571_b(x, y, z);
                if (!this.m_blocks.contains(coords) && this.blockIntersectsBoxXZ(x, z, box)) {
                    blocks.add(new ChunkCoordinates(coords));
                }
                ++z;
            }
            ++x;
        }
        return blocks;
    }

    public List<ChunkCoordinates> rangeQuery(AxisAlignedBB box) {
        int minY = MathHelper.func_76128_c((double)box.field_72338_b);
        int maxY = MathHelper.func_76128_c((double)box.field_72337_e);
        ArrayList<ChunkCoordinates> blocks = new ArrayList<ChunkCoordinates>();
        int y = minY;
        while (y <= maxY) {
            blocks.addAll(this.rangeQuery(box, y));
            ++y;
        }
        return blocks;
    }

    public List<ChunkCoordinates> rangeQuery(AxisAlignedBB box, int y) {
        int minX = MathHelper.func_76128_c((double)box.field_72340_a);
        int minZ = MathHelper.func_76128_c((double)box.field_72339_c);
        int maxX = MathHelper.func_76128_c((double)box.field_72336_d);
        int maxZ = MathHelper.func_76128_c((double)box.field_72334_f);
        ChunkCoordinates coords = new ChunkCoordinates();
        ArrayList<ChunkCoordinates> blocks = new ArrayList<ChunkCoordinates>();
        int x = minX;
        while (x <= maxX) {
            int z = minZ;
            while (z <= maxZ) {
                coords.func_71571_b(x, y, z);
                if (this.m_blocks.contains(coords)) {
                    blocks.add(new ChunkCoordinates(coords));
                }
                ++z;
            }
            ++x;
        }
        return blocks;
    }

    private boolean blockIntersectsBoxXZ(int x, int z, RotatedBB box) {
        double y = (box.getMinY() + box.getMaxY()) / 2.0;
        return box.containsPoint(x + 0, y, z + 0) || box.containsPoint(x + 0, y, z + 1) || box.containsPoint(x + 1, y, z + 0) || box.containsPoint(x + 1, y, z + 1) || this.anyCornerIsInBlockXZ(box, x, z);
    }

    private boolean anyCornerIsInBlockXZ(RotatedBB box, int x, int z) {
        Vec3 p = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        BoxCorner[] boxCornerArray = BlockSide.Top.getCorners();
        int n = boxCornerArray.length;
        int n2 = 0;
        while (n2 < n) {
            BoxCorner corner = boxCornerArray[n2];
            box.getCorner(p, corner);
            if (this.isPointInBlockXZ(p.field_72450_a, p.field_72449_c, x, z)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isPointInBlockXZ(double px, double pz, int blockX, int blockZ) {
        return px >= (double)blockX && px <= (double)(blockX + 1) && pz >= (double)blockZ && pz <= (double)(blockZ + 1);
    }

    private void computeBoundaryAndHoles() {
        TreeSet<ChunkCoordinates> boundaryBlocks = new TreeSet<ChunkCoordinates>();
        ChunkCoordinates neighborCoords = new ChunkCoordinates(0, 0, 0);
        for (ChunkCoordinates chunkCoordinates : this.m_blocks) {
            int i = 0;
            while (i < VoidBlockNeighbors.getNumNeighbors()) {
                VoidBlockNeighbors.getNeighbor(neighborCoords, chunkCoordinates, i);
                if (!this.m_blocks.contains(neighborCoords)) {
                    boundaryBlocks.add(new ChunkCoordinates(neighborCoords));
                }
                ++i;
            }
        }
        this.m_outerBoundaries = new ArrayList<TreeSet<ChunkCoordinates>>();
        this.m_holes = new ArrayList<TreeSet<ChunkCoordinates>>();
        for (TreeSet treeSet : BlockUtils.getConnectedComponents(boundaryBlocks, VoidBlockNeighbors)) {
            if (this.isConnectedToShell((ChunkCoordinates)treeSet.first())) {
                this.m_outerBoundaries.add(treeSet);
                continue;
            }
            this.m_holes.add(BlockUtils.getHoleFromInnerBoundary(treeSet, this.m_blocks, VoidBlockNeighbors));
        }
    }

    private boolean isConnectedToShell(ChunkCoordinates coords) {
        return this.isConnectedToShell(coords, null);
    }

    private boolean isConnectedToShell(ChunkCoordinates coords, final Integer maxY) {
        final BoundingBoxInt box = this.m_envelopes.getBoundingBox();
        int shellVolume = (box.getDx() + 2) * (box.getDy() + 2) * (box.getDz() + 2);
        Boolean result = BlockUtils.searchForCondition(coords, shellVolume, new BlockUtils.BlockConditionValidator(){

            @Override
            public boolean isValid(ChunkCoordinates coords) {
                return !ShipGeometry.this.m_blocks.contains(coords) && (maxY == null || coords.field_71572_b <= maxY);
            }

            @Override
            public boolean isConditionMet(ChunkCoordinates coords) {
                return !box.containsPoint(coords);
            }
        }, VoidBlockNeighbors);
        if (result == null) {
            throw new Error("We evaluated too many blocks checking for the shell. This shouldn't have happened.");
        }
        return result;
    }

    private void computeTrappedAir() {
        if (this.m_blocks == null) {
            throw new Error("Need blocks!");
        }
        if (this.m_outerBoundaries == null || this.m_holes == null) {
            throw new Error("Need boundaries!");
        }
        int minY = this.m_envelopes.getBoundingBox().minY;
        int maxY = this.m_envelopes.getBoundingBox().maxY;
        this.m_trappedAir = new TreeMap();
        int waterLevel = minY;
        while (waterLevel <= maxY + 1) {
            TreeSet<ChunkCoordinates> trappedAirAtThisWaterLevel = new TreeSet<ChunkCoordinates>();
            for (Set set : this.m_holes) {
                trappedAirAtThisWaterLevel.addAll(BlockUtils.getBlocksAtYAndBelow(set, waterLevel));
            }
            ArrayList<TreeSet<ChunkCoordinates>> arrayList = new ArrayList<TreeSet<ChunkCoordinates>>();
            for (TreeSet<ChunkCoordinates> treeSet : this.m_outerBoundaries) {
                TreeSet<ChunkCoordinates> clippedOuterBoundary = BlockUtils.getBlocksAtYAndBelow(treeSet, waterLevel);
                for (TreeSet<ChunkCoordinates> clippedOuterBoundaryComponent : BlockUtils.getConnectedComponents(clippedOuterBoundary, VoidBlockNeighbors)) {
                    if (clippedOuterBoundaryComponent.isEmpty()) continue;
                    arrayList.add(clippedOuterBoundaryComponent);
                }
            }
            for (TreeSet<Object> treeSet : arrayList) {
                if (this.isConnectedToShell((ChunkCoordinates)treeSet.first(), waterLevel)) continue;
                trappedAirAtThisWaterLevel.addAll(BlockUtils.getHoleFromInnerBoundary(treeSet, this.m_blocks, VoidBlockNeighbors, waterLevel));
            }
            this.m_trappedAir.put(waterLevel, trappedAirAtThisWaterLevel);
            ++waterLevel;
        }
    }
}

