/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cuchaz.modsShared.BlockArray;
import cuchaz.modsShared.BlockSide;
import cuchaz.modsShared.BlockUtils;
import cuchaz.modsShared.BoundingBoxInt;
import cuchaz.modsShared.Envelopes;
import cuchaz.ships.EntityShip;
import cuchaz.ships.MaterialProperties;
import cuchaz.ships.ShipGeometry;
import cuchaz.ships.ShipPhysics;
import cuchaz.ships.ShipType;
import cuchaz.ships.ShipWorld;
import cuchaz.ships.Ships;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class ShipLauncher {
    private World m_world;
    private int m_x;
    private int m_y;
    private int m_z;
    private ShipType m_shipType;
    private List<ChunkCoordinates> m_blocks;
    private List<Boolean> m_launchFlags;
    private ShipWorld m_shipWorld;
    private ShipPhysics m_shipPhysics;
    private Double m_equilibriumWaterHeight;

    public ShipLauncher(final World world, int x, int y, int z) {
        this.m_world = world;
        this.m_x = x;
        this.m_y = y;
        this.m_z = z;
        this.m_shipType = Ships.m_blockShip.getShipType(world, x, y, z);
        this.m_blocks = BlockUtils.searchForBlocks(x, y, z, this.m_shipType.getMaxNumBlocks(), new BlockUtils.BlockValidator(){

            @Override
            public boolean isValid(ChunkCoordinates coords) {
                return !MaterialProperties.isSeparatorBlock(Block.field_71973_m[world.func_72798_a(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c)]);
            }
        }, ShipGeometry.ShipBlockNeighbors);
        if (this.m_blocks != null) {
            this.m_blocks.add(new ChunkCoordinates(this.m_x, this.m_y, this.m_z));
            this.m_shipWorld = new ShipWorld(this.m_world, new ChunkCoordinates(this.m_x, this.m_y, this.m_z), this.m_blocks);
            this.m_shipPhysics = new ShipPhysics(this.m_shipWorld);
            this.m_equilibriumWaterHeight = this.m_shipPhysics.getEquilibriumWaterHeight();
        } else {
            this.m_shipWorld = null;
            this.m_shipPhysics = null;
            this.m_equilibriumWaterHeight = null;
        }
        this.m_launchFlags = new ArrayList<Boolean>();
        LaunchFlag[] launchFlagArray = LaunchFlag.values();
        int n = launchFlagArray.length;
        int n2 = 0;
        while (n2 < n) {
            LaunchFlag flag = launchFlagArray[n2];
            this.m_launchFlags.add(flag.computeValue(this));
            ++n2;
        }
    }

    public int getX() {
        return this.m_x;
    }

    public int getY() {
        return this.m_y;
    }

    public int getZ() {
        return this.m_z;
    }

    public ShipType getShipType() {
        return this.m_shipType;
    }

    public ShipWorld getShipWorld() {
        return this.m_shipWorld;
    }

    public ShipPhysics getShipPhysics() {
        return this.m_shipPhysics;
    }

    public int getNumBlocks() {
        return this.m_blocks.size() - 1;
    }

    public boolean getLaunchFlag(LaunchFlag flag) {
        return this.m_launchFlags.get(flag.ordinal());
    }

    public boolean isLaunchable() {
        boolean isValid = true;
        LaunchFlag[] launchFlagArray = LaunchFlag.values();
        int n = launchFlagArray.length;
        int n2 = 0;
        while (n2 < n) {
            LaunchFlag flag = launchFlagArray[n2];
            isValid = isValid && this.getLaunchFlag(flag);
            ++n2;
        }
        return isValid;
    }

    public BlockSide getShipSide() {
        if (this.getShipBoundingBox() == null) {
            return null;
        }
        if (this.getShipBoundingBox().getDx() > this.getShipBoundingBox().getDz()) {
            return BlockSide.North;
        }
        return BlockSide.West;
    }

    public BlockSide getShipFront() {
        if (this.getShipBoundingBox() == null) {
            return null;
        }
        if (this.getShipBoundingBox().getDx() > this.getShipBoundingBox().getDz()) {
            return BlockSide.North;
        }
        return BlockSide.West;
    }

    public BoundingBoxInt getShipBoundingBox() {
        if (this.m_shipWorld == null) {
            return null;
        }
        return this.m_shipWorld.getGeometry().getEnvelopes().getBoundingBox();
    }

    public BlockArray getShipEnvelope(BlockSide side) {
        if (this.m_shipWorld == null) {
            return null;
        }
        return this.m_shipWorld.getGeometry().getEnvelopes().getEnvelope(side);
    }

    public Double getEquilibriumWaterHeight() {
        return this.m_equilibriumWaterHeight;
    }

    public EntityShip launch() {
        int waterHeight = this.computeWaterHeight();
        Vec3 centerOfMass = new ShipPhysics(this.m_shipWorld).getCenterOfMass();
        EntityShip ship = new EntityShip(this.m_world);
        ship.func_70080_a((double)this.m_x + centerOfMass.field_72450_a, (double)this.m_y + centerOfMass.field_72448_b, (double)this.m_z + centerOfMass.field_72449_c, 0.0f, 0.0f);
        ship.setWaterHeight(waterHeight);
        ship.setBlocks(this.m_shipWorld);
        if (!this.m_world.func_72838_d((Entity)ship)) {
            Ships.logger.warning(String.format("Could not spawn ship in world at (%d,%d,%d)", ship.field_70165_t, ship.field_70163_u, ship.field_70161_v));
            return null;
        }
        for (ChunkCoordinates coords : this.m_blocks) {
            BlockUtils.removeBlockWithoutNotifyingIt(this.m_world, coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
            if (coords.field_71572_b >= waterHeight) continue;
            this.m_world.func_94575_c(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, Block.field_71943_B.field_71990_ca);
        }
        return ship;
    }

    private int computeWaterHeight() {
        Envelopes envelopes = this.m_shipWorld.getGeometry().getEnvelopes();
        int x = envelopes.getBoundingBox().minX - 1;
        while (x <= envelopes.getBoundingBox().maxX + 1) {
            int z = envelopes.getBoundingBox().minZ - 1;
            while (z <= envelopes.getBoundingBox().maxZ + 1) {
                int waterHeight = this.computeWaterHeight(x, z);
                if (waterHeight != -1) {
                    return waterHeight;
                }
                ++z;
            }
            ++x;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    private int computeWaterHeight(int blockX, int blockZ) {
        envelopes = this.m_shipWorld.getGeometry().getEnvelopes();
        x = blockX + this.m_x;
        y = envelopes.getBoundingBox().maxY + 1 + this.m_y;
        z = blockZ + this.m_z;
        foundAir = false;
        while (y >= 0) {
            if (this.m_world.func_72803_f(x, y, z) == Material.field_76249_a) {
                foundAir = true;
                break;
            }
            --y;
        }
        if (foundAir) ** GOTO lbl17
        return -1;
lbl-1000:
        // 1 sources

        {
            if (this.m_world.func_72803_f(x, y, z).func_76224_d()) {
                return y + 1;
            }
            --y;
lbl17:
            // 2 sources

            ** while (y >= 0)
        }
lbl18:
        // 1 sources

        return -1;
    }

    private boolean hasWaterBelow(ChunkCoordinates coords) {
        int worldX = coords.field_71574_a + this.m_x;
        int worldY = coords.field_71572_b + this.m_y;
        int worldZ = coords.field_71573_c + this.m_z;
        int y = worldY - 1;
        while (y >= 0) {
            Material material = this.m_world.func_72803_f(worldX, y, worldZ);
            if (material != Material.field_76249_a) {
                return material.func_76224_d();
            }
            --y;
        }
        return false;
    }

    public static enum LaunchFlag {
        RightNumberOfBlocks{

            @Override
            public boolean computeValue(ShipLauncher launcher) {
                return launcher.m_blocks != null && !launcher.m_blocks.isEmpty() && launcher.m_blocks.size() <= launcher.m_shipType.getMaxNumBlocks();
            }
        }
        ,
        HasWaterBelow{

            @Override
            public boolean computeValue(ShipLauncher launcher) {
                if (launcher.m_blocks == null) {
                    return false;
                }
                for (ChunkCoordinates coords : launcher.getShipEnvelope(BlockSide.Bottom)) {
                    if (launcher.hasWaterBelow(coords)) continue;
                    return false;
                }
                return true;
            }
        }
        ,
        HasAirAbove{

            @Override
            public boolean computeValue(ShipLauncher launcher) {
                if (launcher.m_blocks == null) {
                    return false;
                }
                for (ChunkCoordinates coords : launcher.getShipEnvelope(BlockSide.Top)) {
                    int worldX = coords.field_71574_a + launcher.m_x;
                    int worldY = coords.field_71572_b + launcher.m_y;
                    int worldZ = coords.field_71573_c + launcher.m_z;
                    if (launcher.m_world.func_72803_f(worldX, worldY + 1, worldZ) != Material.field_76249_a) continue;
                    return true;
                }
                return false;
            }
        }
        ,
        FoundWaterHeight{

            @Override
            public boolean computeValue(ShipLauncher launcher) {
                if (launcher.m_blocks == null) {
                    return false;
                }
                return launcher.computeWaterHeight() != -1;
            }
        }
        ,
        WillItFloat{

            @Override
            public boolean computeValue(ShipLauncher launcher) {
                if (launcher.m_blocks == null || launcher.m_equilibriumWaterHeight == null) {
                    return false;
                }
                return launcher.m_equilibriumWaterHeight < (double)(launcher.getShipBoundingBox().maxY + 1);
            }
        };


        public abstract boolean computeValue(ShipLauncher var1);
    }
}

