/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cuchaz.ships.EntityShip;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemInWorldManager;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;

public class ShipLocator {
    private static List<EntityShip> m_shipsServer;
    private static List<EntityShip> m_shipsClient;

    static {
        m_shipsClient = new ArrayList<EntityShip>();
        m_shipsServer = new ArrayList<EntityShip>();
    }

    public static List<EntityShip> getShips(Entity entity) {
        if (entity.field_70170_p.field_72995_K) {
            return m_shipsClient;
        }
        return m_shipsServer;
    }

    public static void registerShip(EntityShip ship) {
        ShipLocator.getShips(ship).add(ship);
    }

    public static void unregisterShip(EntityShip ship) {
        ShipLocator.getShips(ship).remove((Object)ship);
    }

    public static EntityShip getFromPlayerLook(EntityPlayer player) {
        Vec3 eyePos = player.field_70170_p.func_82732_R().func_72345_a(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        double toRadians = Math.PI / 180;
        float pitch = (float)((double)player.field_70125_A * (Math.PI / 180));
        float yaw = (float)((double)player.field_70177_z * (Math.PI / 180));
        float cosYaw = MathHelper.func_76134_b((float)(-yaw - (float)Math.PI));
        float sinYaw = MathHelper.func_76126_a((float)(-yaw - (float)Math.PI));
        float cosPitch = MathHelper.func_76134_b((float)(-pitch));
        float sinPitch = MathHelper.func_76126_a((float)(-pitch));
        double reachDistance = new ItemInWorldManager(player.field_70170_p).getBlockReachDistance();
        Vec3 targetPos = eyePos.func_72441_c((double)(sinYaw * -cosPitch) * reachDistance, (double)sinPitch * reachDistance, (double)(cosYaw * -cosPitch) * reachDistance);
        AxisAlignedBB queryBox = player.field_70121_D.func_72329_c();
        queryBox.field_72340_a -= reachDistance;
        queryBox.field_72336_d += reachDistance;
        queryBox.field_72338_b -= reachDistance;
        queryBox.field_72337_e += reachDistance;
        queryBox.field_72339_c -= reachDistance;
        queryBox.field_72334_f += reachDistance;
        for (EntityShip ship : ShipLocator.findShipsInBox((Entity)player, queryBox)) {
            if (!ship.field_70121_D.func_72318_a(eyePos) && !ship.field_70121_D.func_72318_a(targetPos) && ship.field_70121_D.func_72327_a(eyePos, targetPos) == null) continue;
            return ship;
        }
        return null;
    }

    public static List<EntityShip> getFromEntityLocation(Entity entity) {
        AxisAlignedBB queryBox = entity.field_70121_D.func_72329_c();
        double delta = 0.5;
        queryBox.field_72340_a -= 0.5;
        queryBox.field_72338_b -= 0.5;
        queryBox.field_72339_c -= 0.5;
        queryBox.field_72340_a += 0.5;
        queryBox.field_72338_b += 0.5;
        queryBox.field_72339_c += 0.5;
        return ShipLocator.findShipsInBox(entity, queryBox);
    }

    private static List<EntityShip> findShipsInBox(Entity entity, AxisAlignedBB box) {
        ArrayList<EntityShip> ships = new ArrayList<EntityShip>();
        for (EntityShip ship : ShipLocator.getShips(entity)) {
            if (!ship.field_70121_D.func_72326_a(box)) continue;
            ships.add(ship);
        }
        return ships;
    }
}

