/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cuchaz.modsShared.BlockArray;
import cuchaz.modsShared.BlockSide;
import cuchaz.modsShared.Envelopes;
import cuchaz.modsShared.Util;
import cuchaz.ships.MaterialProperties;
import cuchaz.ships.ShipWorld;
import cuchaz.ships.propulsion.Propulsion;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;

public class ShipPhysics {
    private static final double AccelerationGravity = Util.perSecond2ToPerTick2(9.8);
    private static final double AirViscosity = 0.1;
    private static final double WaterViscosity = 4.0;
    private static final double BaseLinearDrag = 0.001;
    private static final float AngularAccelerationFactor = 10.0f;
    private static final float AngularDragViscosity = 0.5f;
    private static final double BaseAngularDrag = 0.1;
    private ShipWorld m_blocks;
    private TreeMap<Integer, DisplacementEntry> m_displacement;
    private double m_shipMass;
    private Double m_equilibriumWaterHeight;

    public ShipPhysics(ShipWorld blocks) {
        this.m_blocks = blocks;
        TreeSet<ChunkCoordinates> watertightBlocks = new TreeSet<ChunkCoordinates>();
        for (ChunkCoordinates coords : this.m_blocks.coords()) {
            if (!MaterialProperties.isWatertight(this.getBlock(coords))) continue;
            watertightBlocks.add(coords);
        }
        int minY = this.m_blocks.getBoundingBox().minY;
        int maxY = this.m_blocks.getBoundingBox().maxY;
        this.m_displacement = new TreeMap();
        int y = minY;
        while (y <= maxY + 1) {
            this.m_displacement.put(y, new DisplacementEntry());
            ++y;
        }
        for (ChunkCoordinates coords : watertightBlocks) {
            int y2 = maxY + 1;
            while (y2 >= coords.field_71572_b) {
                DisplacementEntry entry = this.m_displacement.get(y2);
                if (y2 == coords.field_71572_b) {
                    ++entry.numBlocksAtSurface;
                } else {
                    ++entry.numBlocksUnderwater;
                }
                --y2;
            }
        }
        y = minY;
        while (y <= maxY + 1) {
            DisplacementEntry entry = this.m_displacement.get(y);
            for (ChunkCoordinates coords : this.m_blocks.getGeometry().getTrappedAir(y)) {
                if (y == coords.field_71572_b) {
                    ++entry.numBlocksAtSurface;
                    continue;
                }
                ++entry.numBlocksUnderwater;
            }
            ++y;
        }
        this.m_shipMass = 0.0;
        for (ChunkCoordinates coords : this.m_blocks.coords()) {
            this.m_shipMass += MaterialProperties.getMass(this.getBlock(coords));
        }
        this.m_equilibriumWaterHeight = this.computeEquilibriumWaterHeight();
    }

    public double getMass() {
        return this.m_shipMass;
    }

    public Vec3 getCenterOfMass() {
        Vec3 com = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        double totalMass = 0.0;
        for (ChunkCoordinates coords : this.m_blocks.coords()) {
            double mass = MaterialProperties.getMass(this.getBlock(coords));
            totalMass += mass;
            com.field_72450_a += mass * ((double)coords.field_71574_a + 0.5);
            com.field_72448_b += mass * ((double)coords.field_71572_b + 0.5);
            com.field_72449_c += mass * ((double)coords.field_71573_c + 0.5);
        }
        com.field_72450_a /= totalMass;
        com.field_72448_b /= totalMass;
        com.field_72449_c /= totalMass;
        return com;
    }

    public double getNetUpAcceleration(double waterHeight) {
        return (this.getDisplacedWaterMass(waterHeight) - this.m_shipMass) * AccelerationGravity / this.m_shipMass;
    }

    public double getDisplacedWaterMass(double waterHeight) {
        int surfaceLevel = MathHelper.func_76128_c((double)waterHeight);
        DisplacementEntry entry = this.m_displacement.get(surfaceLevel);
        double displacedWaterMass = 0.0;
        if (entry != null) {
            double surfaceFraction = this.getBlockFractionSubmerged(surfaceLevel, waterHeight);
            displacedWaterMass = ((double)entry.numBlocksUnderwater + (double)entry.numBlocksAtSurface * surfaceFraction) * this.getWaterBlockMass();
        }
        return displacedWaterMass;
    }

    public Double getEquilibriumWaterHeight() {
        return this.m_equilibriumWaterHeight;
    }

    public double getLinearAccelerationDueToThrust(Propulsion propulsion) {
        return propulsion.getTotalThrust() / this.m_shipMass;
    }

    public double getLinearAccelerationDueToDrag(Vec3 velocity, double waterHeight, Envelopes envelopes) {
        BlockSide leadingSide = null;
        double bestDot = Double.NEGATIVE_INFINITY;
        BlockSide[] blockSideArray = BlockSide.values();
        int n = blockSideArray.length;
        int n2 = 0;
        while (n2 < n) {
            BlockSide side = blockSideArray[n2];
            double dot = (double)side.getDx() * velocity.field_72450_a + (double)side.getDy() * velocity.field_72448_b + (double)side.getDz() * velocity.field_72449_c;
            if (dot > bestDot) {
                bestDot = dot;
                leadingSide = side;
            }
            ++n2;
        }
        assert (leadingSide != null);
        BlockArray leadingEnvelope = envelopes.getEnvelope(leadingSide);
        double airSurfaceArea = 0.0;
        double waterSurfaceArea = 0.0;
        for (ChunkCoordinates coords : leadingEnvelope) {
            double fractionSubmerged = leadingSide.getFractionSubmerged(coords.field_71572_b, waterHeight);
            waterSurfaceArea += fractionSubmerged;
            airSurfaceArea += 1.0 - fractionSubmerged;
        }
        double speed = velocity.func_72433_c();
        double dragAcceleration = 0.001 + speed * speed * (0.1 * airSurfaceArea + 4.0 * waterSurfaceArea) / this.m_shipMass;
        if (dragAcceleration > speed) {
            dragAcceleration = speed;
        }
        return dragAcceleration;
    }

    public float getAngularAccelerationDueToThrust(Propulsion propulsion) {
        return (float)this.getLinearAccelerationDueToThrust(propulsion) * 10.0f;
    }

    public float getAngularAccelerationDueToDrag(float motionYaw) {
        float dragForce = motionYaw * motionYaw * 0.5f;
        return 0.1f + dragForce / (float)this.m_shipMass;
    }

    public double getTopLinearSpeed(Propulsion propulsion, Envelopes envelopes) {
        Double waterHeight = this.computeEquilibriumWaterHeight();
        if (waterHeight == null) {
            return 0.0;
        }
        double accelDueToThrust = this.getLinearAccelerationDueToThrust(propulsion);
        double speed = 0.0;
        Vec3 velocity = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        int i = 0;
        while (i < 100) {
            velocity.field_72450_a = speed * (double)propulsion.getFrontSide().getDx();
            velocity.field_72449_c = speed * (double)propulsion.getFrontSide().getDz();
            double accelDueToDrag = this.getLinearAccelerationDueToDrag(velocity, waterHeight, envelopes);
            accelDueToDrag = Math.min(speed, accelDueToDrag);
            double netAcceleration = accelDueToThrust - accelDueToDrag;
            speed += netAcceleration;
            if (Math.abs(netAcceleration) < 0.01) break;
            ++i;
        }
        return speed;
    }

    public float getTopAngularSpeed(Propulsion propulsion) {
        double thrustAccel = this.getAngularAccelerationDueToThrust(propulsion);
        float speed = 0.0f;
        int i = 0;
        while (i < 100) {
            double netAcceleration = thrustAccel - (double)this.getAngularAccelerationDueToDrag(speed);
            speed = (float)((double)speed + netAcceleration);
            if (Math.abs(netAcceleration) < 0.01) break;
            ++i;
        }
        return speed;
    }

    private Double computeEquilibriumWaterHeight() {
        int minY = this.m_blocks.getBoundingBox().minY;
        int maxY = this.m_blocks.getBoundingBox().maxY;
        int y = minY;
        while (y <= maxY + 1) {
            DisplacementEntry entry = this.m_displacement.get(y);
            double displacedWaterMass = (double)(entry.numBlocksUnderwater + entry.numBlocksAtSurface) * this.getWaterBlockMass();
            if (displacedWaterMass > this.m_shipMass) {
                return (double)y + (this.m_shipMass - (double)entry.numBlocksUnderwater * this.getWaterBlockMass()) / (double)entry.numBlocksAtSurface / this.getWaterBlockMass();
            }
            ++y;
        }
        return null;
    }

    private double getBlockFractionSubmerged(int y, double waterHeight) {
        return BlockSide.North.getFractionSubmerged(y, waterHeight);
    }

    private Block getBlock(ChunkCoordinates coords) {
        return Block.field_71973_m[this.m_blocks.func_72798_a(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c)];
    }

    private double getWaterBlockMass() {
        return MaterialProperties.getMass(Block.field_71943_B);
    }

    private static class DisplacementEntry {
        public int numBlocksAtSurface = 0;
        public int numBlocksUnderwater = 0;
    }
}

