/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cuchaz.ships.Ships;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

public enum ShipType {
    Tiny(20, true){

        @Override
        protected void registerBlock() {
            LanguageRegistry.addName((Object)this.newItemStack(), (String)"Tiny Ship");
            GameRegistry.addRecipe((ItemStack)this.newItemStack(), (Object[])new Object[]{"xxx", "xyx", "xxx", Character.valueOf('x'), new ItemStack(Item.field_77703_o), Character.valueOf('y'), new ItemStack(Item.field_77767_aC)});
        }
    }
    ,
    Small(200, false){

        @Override
        protected void registerBlock() {
            LanguageRegistry.addName((Object)this.newItemStack(), (String)"Small Ship");
            GameRegistry.addRecipe((ItemStack)this.newItemStack(), (Object[])new Object[]{"xzx", "zyz", "xzx", Character.valueOf('x'), new ItemStack(Item.field_77703_o), Character.valueOf('y'), new ItemStack(Item.field_77767_aC), Character.valueOf('z'), new ItemStack(Item.field_77717_p)});
        }
    };

    private int m_maxNumBlocks;
    private boolean m_isPaddleable;
    @SideOnly(value=Side.CLIENT)
    private Icon m_icon;

    private ShipType(int maxNumBlocks, boolean isPaddleable) {
        this.m_maxNumBlocks = maxNumBlocks;
        this.m_isPaddleable = isPaddleable;
    }

    public int getMaxNumBlocks() {
        return this.m_maxNumBlocks;
    }

    public boolean isPaddleable() {
        return this.m_isPaddleable;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerIcons(IconRegister iconRegister) {
        ShipType[] shipTypeArray = ShipType.values();
        int n = shipTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ShipType type = shipTypeArray[n2];
            type.m_icon = iconRegister.func_94245_a("ships:shipSide-" + type.name().toLowerCase());
            ++n2;
        }
    }

    public Icon getIcon() {
        return this.m_icon;
    }

    public static ShipType getByMeta(int meta) {
        return ShipType.values()[meta];
    }

    public int getMeta() {
        return this.ordinal();
    }

    public ItemStack newItemStack() {
        return new ItemStack((Block)Ships.m_blockShip, 1, this.getMeta());
    }

    public static void registerBlocks() {
        ShipType[] shipTypeArray = ShipType.values();
        int n = shipTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ShipType type = shipTypeArray[n2];
            type.registerBlock();
            ++n2;
        }
    }

    protected abstract void registerBlock();

    /* synthetic */ ShipType(String string, int n, int n2, boolean bl, ShipType shipType) {
        this(n2, bl);
    }
}

