/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cuchaz.modsShared.BlockSide;
import cuchaz.modsShared.CircleRange;
import cuchaz.modsShared.Util;
import cuchaz.ships.EntityShip;
import cuchaz.ships.MaterialProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;

public class ShipUnlauncher {
    private EntityShip m_ship;
    private List<Boolean> m_unlaunchFlags;
    private TreeMap<ChunkCoordinates, ChunkCoordinates> m_correspondence;
    private int m_waterSurfaceLevelBlocks;

    public ShipUnlauncher(EntityShip ship) {
        this.m_ship = ship;
        this.computeCorrespondence();
        this.m_unlaunchFlags = new ArrayList<Boolean>();
        UnlaunchFlag[] unlaunchFlagArray = UnlaunchFlag.values();
        int n = unlaunchFlagArray.length;
        int n2 = 0;
        while (n2 < n) {
            UnlaunchFlag flag = unlaunchFlagArray[n2];
            this.m_unlaunchFlags.add(flag.computeValue(this));
            ++n2;
        }
    }

    private void computeCorrespondence() {
        Vec3 p = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        this.m_ship.blocksToShip(p);
        this.m_ship.shipToWorld(p);
        ChunkCoordinates shipBlock = new ChunkCoordinates(MathHelper.func_76128_c((double)(p.field_72450_a + 0.5)), MathHelper.func_76143_f((double)p.field_72448_b), MathHelper.func_76128_c((double)(p.field_72449_c + 0.5)));
        this.m_waterSurfaceLevelBlocks = this.m_ship.getWaterHeight() - shipBlock.field_71572_b - 1;
        TreeSet<ChunkCoordinates> allCoords = new TreeSet<ChunkCoordinates>();
        allCoords.addAll(this.m_ship.getBlocks().coords());
        allCoords.addAll(this.m_ship.getBlocks().getGeometry().getTrappedAir(this.m_waterSurfaceLevelBlocks));
        double yaw = CircleRange.mapZeroToTwoPi(Math.toRadians(this.m_ship.field_70177_z));
        int rotation = Util.realModulus((int)(yaw / Math.PI * 2.0 + 0.5), 4);
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[2] = -1;
        int cos = nArray[rotation];
        int[] nArray2 = new int[4];
        nArray2[1] = 1;
        nArray2[3] = -1;
        int sin = nArray2[rotation];
        this.m_correspondence = new TreeMap();
        for (ChunkCoordinates coords : allCoords) {
            int x = coords.field_71574_a * cos + coords.field_71573_c * sin;
            int z = -coords.field_71574_a * sin + coords.field_71573_c * cos;
            ChunkCoordinates worldCoords = new ChunkCoordinates(x, coords.field_71572_b, z);
            worldCoords.field_71574_a += shipBlock.field_71574_a;
            worldCoords.field_71572_b += shipBlock.field_71572_b;
            worldCoords.field_71573_c += shipBlock.field_71573_c;
            this.m_correspondence.put(coords, worldCoords);
        }
    }

    public boolean getUnlaunchFlag(UnlaunchFlag flag) {
        return this.m_unlaunchFlags.get(flag.ordinal());
    }

    public boolean isUnlaunchable() {
        boolean isValid = true;
        UnlaunchFlag[] unlaunchFlagArray = UnlaunchFlag.values();
        int n = unlaunchFlagArray.length;
        int n2 = 0;
        while (n2 < n) {
            UnlaunchFlag flag = unlaunchFlagArray[n2];
            isValid = isValid && this.getUnlaunchFlag(flag);
            ++n2;
        }
        return isValid;
    }

    public void unlaunch() {
        List<Entity> riders = this.m_ship.getCollider().getRiders();
        this.m_ship.func_70106_y();
        this.m_ship.getBlocks().restoreToWorld(this.m_ship.field_70170_p, this.m_correspondence, this.m_waterSurfaceLevelBlocks);
        Vec3 sourceShipBlock = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        this.m_ship.blocksToShip(sourceShipBlock);
        this.m_ship.shipToWorld(sourceShipBlock);
        ChunkCoordinates targetShipBlock = this.m_correspondence.get(new ChunkCoordinates(0, 0, 0));
        double dx = (double)targetShipBlock.field_71574_a - sourceShipBlock.field_72450_a;
        double dy = (double)targetShipBlock.field_71572_b - sourceShipBlock.field_72448_b;
        double dz = (double)targetShipBlock.field_71573_c - sourceShipBlock.field_72449_c;
        for (Entity entity : riders) {
            entity.func_70107_b(entity.field_70165_t + dx, entity.field_70163_u + dy, entity.field_70161_v + dz);
        }
    }

    public void snapToNearestDirection() {
        double yaw = CircleRange.mapZeroToTwoPi(Math.toRadians(this.m_ship.field_70177_z));
        double snappedYaw = (double)((int)(yaw / Math.PI * 2.0 + 0.5)) * Math.PI / 2.0;
        this.m_ship.func_70080_a(this.m_ship.field_70165_t, this.m_ship.field_70163_u, this.m_ship.field_70161_v, (float)snappedYaw, this.m_ship.field_70125_A);
    }

    public static enum UnlaunchFlag {
        AlignedToDirection{

            @Override
            public boolean computeValue(ShipUnlauncher unlauncher) {
                return (double)Math.abs(MathHelper.func_76142_g((float)((ShipUnlauncher)unlauncher).m_ship.field_70177_z)) < 10.0;
            }
        }
        ,
        TouchingOnlySeparatorBlocks{

            @Override
            public boolean computeValue(ShipUnlauncher unlauncher) {
                TreeSet placedBlocks = new TreeSet();
                placedBlocks.addAll(unlauncher.m_correspondence.values());
                ChunkCoordinates neighborCoords = new ChunkCoordinates(0, 0, 0);
                for (ChunkCoordinates coords : placedBlocks) {
                    BlockSide[] blockSideArray = BlockSide.values();
                    int n = blockSideArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        BlockSide side = blockSideArray[n2];
                        neighborCoords.field_71574_a = coords.field_71574_a + side.getDx();
                        neighborCoords.field_71572_b = coords.field_71572_b + side.getDy();
                        neighborCoords.field_71573_c = coords.field_71573_c + side.getDz();
                        if (!placedBlocks.contains(neighborCoords) && !MaterialProperties.isSeparatorBlock(this.getBlock((IBlockAccess)((ShipUnlauncher)unlauncher).m_ship.field_70170_p, neighborCoords))) {
                            return false;
                        }
                        ++n2;
                    }
                }
                return true;
            }
        };


        public abstract boolean computeValue(ShipUnlauncher var1);

        protected Block getBlock(IBlockAccess world, ChunkCoordinates coords) {
            return Block.field_71973_m[world.func_72798_a(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c)];
        }
    }
}

