/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cuchaz.modsShared.BlockUtils;
import cuchaz.modsShared.BoundingBoxInt;
import cuchaz.ships.DetatchedWorld;
import cuchaz.ships.EntityShip;
import cuchaz.ships.ShipGeometry;
import cuchaz.ships.ShipType;
import cuchaz.ships.Ships;
import cuchaz.ships.packets.PacketChangedBlocks;
import cuchaz.ships.packets.PacketShipBlockEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet62LevelSound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class ShipWorld
extends DetatchedWorld {
    private ChunkCoordinates m_lookupCoords = new ChunkCoordinates(0, 0, 0);
    private EntityShip m_ship;
    private TreeMap<ChunkCoordinates, BlockStorage> m_blocks;
    private final BlockStorage m_airBlockStorage;
    private ShipGeometry m_geometry;
    private TreeMap<ChunkCoordinates, TileEntity> m_tileEntities;
    private TreeSet<ChunkCoordinates> m_changedBlocks;

    public ShipWorld(World world, int foo) {
        super(world, "nothing");
        this.m_airBlockStorage = null;
    }

    private ShipWorld(World world) {
        super(world, "Ship");
        this.m_ship = null;
        this.m_blocks = null;
        this.m_airBlockStorage = new BlockStorage();
        this.m_geometry = null;
        this.m_tileEntities = null;
        this.m_changedBlocks = new TreeSet();
    }

    public ShipWorld(World world, ChunkCoordinates originCoords, List<ChunkCoordinates> blocks) {
        this(world);
        ChunkCoordinates relativeCoords;
        this.m_blocks = new TreeMap();
        for (ChunkCoordinates worldCoords : blocks) {
            BlockStorage storage = new BlockStorage();
            storage.copyFromWorld(world, worldCoords);
            relativeCoords = new ChunkCoordinates(worldCoords.field_71574_a - originCoords.field_71574_a, worldCoords.field_71572_b - originCoords.field_71572_b, worldCoords.field_71573_c - originCoords.field_71573_c);
            this.m_blocks.put(relativeCoords, storage);
        }
        this.m_tileEntities = new TreeMap();
        for (ChunkCoordinates worldCoords : blocks) {
            TileEntity tileEntity = world.func_72796_p(worldCoords.field_71574_a, worldCoords.field_71572_b, worldCoords.field_71573_c);
            if (tileEntity == null) continue;
            relativeCoords = new ChunkCoordinates(worldCoords.field_71574_a - originCoords.field_71574_a, worldCoords.field_71572_b - originCoords.field_71572_b, worldCoords.field_71573_c - originCoords.field_71573_c);
            NBTTagCompound nbt = new NBTTagCompound();
            tileEntity.func_70310_b(nbt);
            TileEntity tileEntityCopy = TileEntity.func_70317_c((NBTTagCompound)nbt);
            tileEntityCopy.func_70308_a((World)this);
            tileEntityCopy.field_70329_l = relativeCoords.field_71574_a;
            tileEntityCopy.field_70330_m = relativeCoords.field_71572_b;
            tileEntityCopy.field_70327_n = relativeCoords.field_71573_c;
            tileEntityCopy.func_70312_q();
            this.m_tileEntities.put(relativeCoords, tileEntityCopy);
        }
        this.computeDependentFields();
    }

    public ShipWorld(World world, byte[] data) {
        this(world);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        try {
            int version = in.readInt();
            if (version != 1) {
                Ships.logger.warning("ShipBlocks persistence version " + version + " not supported! Blocks loading skipped!");
            } else {
                this.m_blocks = new TreeMap();
                int numBlocks = in.readInt();
                int i = 0;
                while (i < numBlocks) {
                    ChunkCoordinates coords = new ChunkCoordinates(in.readInt(), in.readInt(), in.readInt());
                    BlockStorage storage = new BlockStorage();
                    storage.readData(in);
                    this.m_blocks.put(coords, storage);
                    ++i;
                }
                this.m_tileEntities = new TreeMap();
                int numTileEntities = in.readInt();
                int i2 = 0;
                while (i2 < numTileEntities) {
                    NBTTagCompound nbt = (NBTTagCompound)NBTBase.func_74739_b((DataInput)in);
                    TileEntity tileEntity = TileEntity.func_70317_c((NBTTagCompound)nbt);
                    ChunkCoordinates coords = new ChunkCoordinates(tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n);
                    tileEntity.func_70308_a((World)this);
                    tileEntity.func_70312_q();
                    this.m_tileEntities.put(coords, tileEntity);
                    ++i2;
                }
                this.computeDependentFields();
            }
        }
        catch (IOException ex) {
            throw new Error("Unable to deserialize blocks!", ex);
        }
    }

    private void computeDependentFields() {
        this.m_geometry = new ShipGeometry(this.m_blocks.keySet());
    }

    public void restoreToWorld(World world, Map<ChunkCoordinates, ChunkCoordinates> correspondence, int waterSurfaceLevelBlocks) {
        for (Map.Entry<ChunkCoordinates, BlockStorage> entry : this.m_blocks.entrySet()) {
            ChunkCoordinates coordsShip = entry.getKey();
            ChunkCoordinates coordsWorld = correspondence.get(coordsShip);
            BlockStorage storage = entry.getValue();
            TileEntity tileEntity = this.getBlockTileEntity(coordsShip);
            if (tileEntity != null) {
                NBTTagCompound nbt = new NBTTagCompound();
                tileEntity.func_70310_b(nbt);
                TileEntity tileEntityCopy = TileEntity.func_70317_c((NBTTagCompound)nbt);
                tileEntityCopy.func_70312_q();
                storage.copyToWorld(world, coordsWorld);
                world.func_72837_a(coordsWorld.field_71574_a, coordsWorld.field_71572_b, coordsWorld.field_71573_c, tileEntityCopy);
                continue;
            }
            storage.copyToWorld(world, coordsWorld);
        }
        for (ChunkCoordinates coordsShip : this.m_geometry.getTrappedAir(waterSurfaceLevelBlocks)) {
            ChunkCoordinates coordsWorld = correspondence.get(coordsShip);
            world.func_94571_i(coordsWorld.field_71574_a, coordsWorld.field_71572_b, coordsWorld.field_71573_c);
        }
    }

    public EntityShip getShip() {
        return this.m_ship;
    }

    public void setShip(EntityShip val) {
        this.m_ship = val;
    }

    public ShipType getShipType() {
        return ShipType.getByMeta(this.func_72805_g(0, 0, 0));
    }

    public boolean isValid() {
        return this.m_blocks != null;
    }

    public int getNumBlocks() {
        return this.m_blocks.size();
    }

    public Set<ChunkCoordinates> coords() {
        return this.m_blocks.keySet();
    }

    public Set<Map.Entry<ChunkCoordinates, TileEntity>> tileEntities() {
        return this.m_tileEntities.entrySet();
    }

    public ShipGeometry getGeometry() {
        return this.m_geometry;
    }

    public BoundingBoxInt getBoundingBox() {
        return this.m_geometry.getEnvelopes().getBoundingBox();
    }

    public BlockStorage getStorage(int x, int y, int z) {
        this.m_lookupCoords.func_71571_b(x, y, z);
        return this.getStorage(this.m_lookupCoords);
    }

    public BlockStorage getStorage(ChunkCoordinates coords) {
        BlockStorage storage = this.m_blocks.get(coords);
        if (storage == null) {
            storage = this.m_airBlockStorage;
        }
        return storage;
    }

    public int func_72798_a(int x, int y, int z) {
        this.m_lookupCoords.func_71571_b(x, y, z);
        return this.getBlockId(this.m_lookupCoords);
    }

    public int getBlockId(ChunkCoordinates coords) {
        return this.getStorage((ChunkCoordinates)coords).blockId;
    }

    public TileEntity func_72796_p(int x, int y, int z) {
        this.m_lookupCoords.func_71571_b(x, y, z);
        return this.getBlockTileEntity(this.m_lookupCoords);
    }

    public TileEntity getBlockTileEntity(ChunkCoordinates coords) {
        return this.m_tileEntities.get(coords);
    }

    public int func_72805_g(int x, int y, int z) {
        this.m_lookupCoords.func_71571_b(x, y, z);
        return this.getBlockMetadata(this.m_lookupCoords);
    }

    public int getBlockMetadata(ChunkCoordinates coords) {
        return this.getStorage((ChunkCoordinates)coords).blockMeta;
    }

    public boolean func_72832_d(int x, int y, int z, int newBlockId, int newMeta, int ignored) {
        if (this.applyBlockChange(x, y, z, newBlockId, newMeta)) {
            if (!this.field_72995_K) {
                this.m_changedBlocks.add(new ChunkCoordinates(x, y, z));
            }
            return true;
        }
        return false;
    }

    public void func_72837_a(int x, int y, int z, TileEntity tileEntity) {
    }

    public boolean func_72921_c(int x, int y, int z, int meta, int ignored) {
        if (this.applyBlockChange(x, y, z, this.func_72798_a(x, y, z), meta)) {
            if (!this.field_72995_K) {
                this.m_changedBlocks.add(new ChunkCoordinates(x, y, z));
            }
            return true;
        }
        return false;
    }

    public boolean applyBlockChange(int x, int y, int z, int newBlockId, int newMeta) {
        this.m_lookupCoords.func_71571_b(x, y, z);
        return this.applyBlockChange(this.m_lookupCoords, newBlockId, newMeta);
    }

    public boolean applyBlockChange(ChunkCoordinates coords, int newBlockId, int newMeta) {
        boolean isAllowed;
        BlockStorage storage = this.getStorage(coords);
        int oldBlockId = storage.blockId;
        boolean bl = isAllowed = oldBlockId == newBlockId || oldBlockId == Block.field_72052_aC.field_71990_ca && newBlockId == Block.field_72051_aB.field_71990_ca || oldBlockId == Block.field_72051_aB.field_71990_ca && newBlockId == Block.field_72052_aC.field_71990_ca;
        if (isAllowed) {
            storage.blockId = newBlockId;
            storage.blockMeta = newMeta;
            TileEntity tileEntity = this.getBlockTileEntity(coords);
            if (tileEntity != null) {
                tileEntity.func_70321_h();
            }
        }
        return isAllowed;
    }

    public boolean isBlockSolidOnSide(int x, int y, int z, ForgeDirection side, boolean defaultValue) {
        this.m_lookupCoords.func_71571_b(x, y, z);
        Block block = Block.field_71973_m[this.getBlockId(this.m_lookupCoords)];
        if (block == null) {
            return defaultValue;
        }
        return block.isBlockSolidOnSide((World)this, x, y, z, side);
    }

    @Override
    public int func_72802_i(int x, int y, int z, int blockBrightness) {
        if (this.m_ship == null) {
            return 0;
        }
        Vec3 v = Vec3.func_72443_a((double)x, (double)y, (double)z);
        this.m_ship.blocksToShip(v);
        this.m_ship.shipToWorld(v);
        x = MathHelper.func_76128_c((double)v.field_72450_a);
        y = MathHelper.func_76128_c((double)v.field_72448_b);
        z = MathHelper.func_76128_c((double)v.field_72449_c);
        return this.m_ship.field_70170_p.func_72802_i(x, y, z, blockBrightness);
    }

    public List func_72872_a(Class theClass, AxisAlignedBB box) {
        return new ArrayList();
    }

    public void func_72944_b(int x, int y, int z, TileEntity tileEntity) {
    }

    public void func_72939_s() {
        for (TileEntity entity : this.m_tileEntities.values()) {
            entity.func_70316_g();
        }
        if (this.field_72995_K && this.m_ship != null) {
            this.updateEntitiesClient();
        }
        if (!this.field_72995_K && !this.m_changedBlocks.isEmpty()) {
            this.pushBlockChangesToClients();
            this.m_changedBlocks.clear();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateEntitiesClient() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        Vec3 v = Vec3.func_72443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v);
        this.m_ship.worldToShip(v);
        this.m_ship.shipToBlocks(v);
        int playerX = MathHelper.func_76128_c((double)v.field_72450_a);
        int playerY = MathHelper.func_76128_c((double)v.field_72448_b);
        int playerZ = MathHelper.func_76128_c((double)v.field_72449_c);
        Random random = new Random();
        int i = 0;
        while (i < 1000) {
            int z;
            int y;
            int x = playerX + random.nextInt(16) - random.nextInt(16);
            int blockId = this.func_72798_a(x, y = playerY + random.nextInt(16) - random.nextInt(16), z = playerZ + random.nextInt(16) - random.nextInt(16));
            if (blockId > 0) {
                Block.field_71973_m[blockId].func_71862_a((World)this, x, y, z, random);
            }
            ++i;
        }
    }

    private void pushBlockChangesToClients() {
        if (this.m_ship == null) {
            return;
        }
        MinecraftServer.func_71276_C().func_71203_ab().func_72393_a(this.m_ship.field_70165_t, this.m_ship.field_70163_u, this.m_ship.field_70161_v, 64.0, this.m_ship.field_70170_p.field_73011_w.field_76574_g, (Packet)new PacketChangedBlocks(this.m_ship, this.m_changedBlocks).getCustomPacket());
    }

    public void func_72965_b(int x, int y, int z, int blockId, int eventId, int eventParam) {
        if (this.m_ship == null || blockId == 0 || this.func_72798_a(x, y, z) != blockId) {
            return;
        }
        boolean eventWasAccepted = Block.field_71973_m[blockId].func_71883_b((World)this, x, y, z, eventId, eventParam);
        if (!this.field_72995_K && eventWasAccepted) {
            Vec3 v = Vec3.func_72443_a((double)x, (double)y, (double)z);
            this.m_ship.blocksToShip(v);
            this.m_ship.shipToWorld(v);
            MinecraftServer.func_71276_C().func_71203_ab().func_72393_a(v.field_72450_a, v.field_72448_b, v.field_72449_c, 64.0, this.m_ship.field_70170_p.field_73011_w.field_76574_g, (Packet)new PacketShipBlockEvent(this.m_ship.field_70157_k, x, y, z, blockId, eventId, eventParam).getCustomPacket());
        }
    }

    public void func_72908_a(double x, double y, double z, String sound, float volume, float pitch) {
        if (sound == null) {
            return;
        }
        if (!this.field_72995_K) {
            Vec3 v = Vec3.func_72443_a((double)x, (double)y, (double)z);
            this.m_ship.blocksToShip(v);
            this.m_ship.shipToWorld(v);
            MinecraftServer.func_71276_C().func_71203_ab().func_72393_a(v.field_72450_a, v.field_72448_b, v.field_72449_c, volume > 1.0f ? (double)(16.0f * volume) : 16.0, this.m_ship.field_70170_p.field_73011_w.field_76574_g, (Packet)new Packet62LevelSound(sound, v.field_72450_a, v.field_72448_b, v.field_72449_c, volume, pitch));
        }
    }

    public void func_72869_a(String name, double x, double y, double z, double motionX, double motionY, double motionZ) {
        if (this.m_ship == null) {
            return;
        }
        Vec3 v = Vec3.func_72443_a((double)x, (double)y, (double)z);
        this.m_ship.blocksToShip(v);
        this.m_ship.shipToWorld(v);
        x = v.field_72450_a;
        y = v.field_72448_b;
        z = v.field_72449_c;
        v.field_72450_a = motionX;
        v.field_72448_b = motionY;
        v.field_72449_c = motionZ;
        this.m_ship.shipToWorldDirection(v);
        motionX = v.field_72450_a;
        motionY = v.field_72448_b;
        motionZ = v.field_72449_c;
        this.m_ship.field_70170_p.func_72869_a(name, x, y, z, motionX, motionY, motionZ);
    }

    public byte[] getData() {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(data);
        try {
            out.writeInt(1);
            out.writeInt(this.m_blocks.size());
            for (Map.Entry<ChunkCoordinates, BlockStorage> entry : this.m_blocks.entrySet()) {
                ChunkCoordinates coords = entry.getKey();
                BlockStorage storage = entry.getValue();
                out.writeInt(coords.field_71574_a);
                out.writeInt(coords.field_71572_b);
                out.writeInt(coords.field_71573_c);
                storage.writeData(out);
            }
            out.writeInt(this.m_tileEntities.size());
            for (TileEntity tileEntity : this.m_tileEntities.values()) {
                NBTTagCompound nbt = new NBTTagCompound();
                tileEntity.func_70310_b(nbt);
                NBTBase.func_74731_a((NBTBase)nbt, (DataOutput)out);
            }
        }
        catch (IOException ex) {
            throw new Error("Unable to serialize blocks!", ex);
        }
        return data.toByteArray();
    }

    private static class BlockStorage {
        public int blockId = 0;
        public int blockMeta = 0;

        public void writeData(DataOutputStream out) throws IOException {
            out.writeInt(this.blockId);
            out.writeInt(this.blockMeta);
        }

        public void readData(DataInputStream in) throws IOException {
            this.blockId = in.readInt();
            this.blockMeta = in.readInt();
        }

        public void copyFromWorld(World world, ChunkCoordinates coords) {
            this.blockId = world.func_72798_a(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
            this.blockMeta = world.func_72805_g(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
        }

        public void copyToWorld(World world, ChunkCoordinates coords) {
            BlockUtils.changeBlockWithoutNotifyingIt(world, coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, this.blockId, this.blockMeta);
        }
    }
}

