/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import com.google.common.base.Function;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.client.FMLFileResourcePack;
import cpw.mods.fml.client.FMLFolderResourcePack;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.network.FMLNetworkHandler;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cuchaz.modsShared.FMLHacker;
import cuchaz.ships.BlockAirWall;
import cuchaz.ships.BlockHelm;
import cuchaz.ships.BlockShip;
import cuchaz.ships.EntityShip;
import cuchaz.ships.EntityShipSpawner;
import cuchaz.ships.ItemMagicBucket;
import cuchaz.ships.ItemMagicShipLevitator;
import cuchaz.ships.ItemPaddle;
import cuchaz.ships.ItemShipClipboard;
import cuchaz.ships.MaterialAirWall;
import cuchaz.ships.ShipItemBlock;
import cuchaz.ships.ShipType;
import cuchaz.ships.TileEntityHelm;
import cuchaz.ships.gui.Gui;
import cuchaz.ships.gui.GuiString;
import cuchaz.ships.packets.PacketHandler;
import cuchaz.ships.propulsion.PropulsionDiscovererRegistry;
import cuchaz.ships.propulsion.SailDiscoverer;
import cuchaz.ships.render.RenderShip;
import cuchaz.ships.render.TileEntityHelmRenderer;
import java.io.File;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

@NetworkMod(channels={"launchShip", "unlaunchShip", "pilotShip", "shipBlockEvent", "changedBlocks", "shipBlocks", "shipBlocksRqst"}, packetHandler=PacketHandler.class, clientSideRequired=true, serverSideRequired=false)
public class Ships
extends DummyModContainer {
    public static Ships instance = null;
    public static Logger logger = Logger.getLogger("cuchaz.ships");
    public static final Material m_materialAirWall = new MaterialAirWall(MapColor.field_76279_b);
    public static final ItemPaddle m_itemPaddle = new ItemPaddle(7321);
    public static final ItemMagicBucket m_itemMagicBucket = new ItemMagicBucket(7322);
    public static final ItemMagicShipLevitator m_itemMagicShipLevitator = new ItemMagicShipLevitator(7323);
    public static final ItemShipClipboard m_itemShipClipboard = new ItemShipClipboard(7324);
    public static final BlockShip m_blockShip = new BlockShip(3170);
    public static final BlockAirWall m_blockAirWall = new BlockAirWall(3171);
    public static final BlockHelm m_blockHelm = new BlockHelm(3712);
    public static final int EntityShipId = 174;
    private File m_source;

    public Ships() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.modId = "cuchaz.ships";
        meta.name = "Ships Mod";
        meta.version = "0.2 BETA";
        meta.authorList = Arrays.asList("Cuchaz");
        meta.description = "Build sailable ships out of blocks.";
        meta.url = "";
        this.m_source = FMLHacker.getModSource(((Object)((Object)this)).getClass());
        if (instance != null) {
            throw new Error("An instance of ships was already active!");
        }
        instance = this;
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    public Object getMod() {
        return this;
    }

    public boolean isNetworkMod() {
        return true;
    }

    public boolean isImmutable() {
        return false;
    }

    public File getSource() {
        return this.m_source;
    }

    public Class<?> getCustomResourcePackClass() {
        if (this.getSource().isDirectory()) {
            return FMLFolderResourcePack.class;
        }
        return FMLFileResourcePack.class;
    }

    @Subscribe
    public void construct(FMLConstructionEvent event) {
        try {
            FMLHacker.unwrapModContainer((ModContainer)this);
            event.getASMHarvestedData().addContainer((ModContainer)this);
            FMLNetworkHandler.instance().registerNetworkMod((ModContainer)this, ((Object)((Object)this)).getClass(), event.getASMHarvestedData());
        }
        catch (RuntimeException ex) {
            logger.log(Level.WARNING, "Unable to construct mod container!", ex);
        }
    }

    @Subscribe
    public void load(FMLInitializationEvent event) {
        try {
            this.loadThings();
            this.loadLanguage();
            this.loadRecipes();
            this.loadPropulsion();
            if (event.getSide().isClient()) {
                this.loadClient();
            }
            NetworkRegistry.instance().registerGuiHandler((Object)this, new IGuiHandler(){

                public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
                    return Gui.values()[id].getContainer(player, world, x, y, z);
                }

                public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
                    return Gui.values()[id].getGui(player, world, x, y, z);
                }
            });
        }
        catch (Throwable ex) {
            logger.log(Level.WARNING, "Exception occurred while loading mod.", ex);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void loadClient() {
        RenderingRegistry.registerEntityRenderingHandler(EntityShip.class, (Render)new RenderShip());
        this.registerTileEntityRenderer(TileEntityHelm.class, new TileEntityHelmRenderer());
        EntityRegistry.instance().lookupModSpawn(EntityShip.class, true).setCustomSpawning((Function)new EntityShipSpawner(), false);
    }

    @SideOnly(value=Side.CLIENT)
    private void registerTileEntityRenderer(Class<? extends TileEntity> c, TileEntitySpecialRenderer renderer) {
        TileEntityRenderer.field_76963_a.field_76966_m.put(c, renderer);
        renderer.func_76893_a(TileEntityRenderer.field_76963_a);
    }

    private void loadThings() {
        GameRegistry.registerBlock((Block)m_blockShip, ShipItemBlock.class, (String)"blockShip");
        ShipType.registerBlocks();
        GameRegistry.registerBlock((Block)m_blockAirWall, (String)"blockAirWall");
        GameRegistry.registerBlock((Block)m_blockHelm, (String)"blockHelm");
        GameRegistry.registerItem((Item)m_itemPaddle, (String)"paddle");
        GameRegistry.registerItem((Item)m_itemMagicBucket, (String)"magicBucket");
        GameRegistry.registerItem((Item)m_itemMagicShipLevitator, (String)"magicShipLevitator");
        GameRegistry.registerItem((Item)m_itemShipClipboard, (String)"shipClipboard");
        EntityRegistry.registerGlobalEntityID(EntityShip.class, (String)"Ship", (int)174);
        EntityRegistry.registerModEntity(EntityShip.class, (String)"Ship", (int)174, (Object)((Object)this), (int)256, (int)10, (boolean)true);
        GameRegistry.registerTileEntity(TileEntityHelm.class, (String)"helm");
    }

    private void loadLanguage() {
        LanguageRegistry.addName((Object)((Object)m_blockAirWall), (String)"Air Wall");
        LanguageRegistry.addName((Object)((Object)m_blockHelm), (String)"Helm");
        LanguageRegistry.addName((Object)((Object)m_itemPaddle), (String)"Paddle");
        LanguageRegistry.addName((Object)((Object)m_itemMagicBucket), (String)"Magic Bucket");
        LanguageRegistry.addName((Object)((Object)m_itemMagicShipLevitator), (String)"Magic Ship Levitator");
        LanguageRegistry.addName((Object)((Object)m_itemShipClipboard), (String)"Ship Clipboard");
        GuiString[] guiStringArray = GuiString.values();
        int n = guiStringArray.length;
        int n2 = 0;
        while (n2 < n) {
            GuiString string = guiStringArray[n2];
            LanguageRegistry.instance().addStringLocalization(string.getKey(), string.getUnlocalizedText());
            ++n2;
        }
    }

    private void loadRecipes() {
        ItemStack stickStack = new ItemStack(Item.field_77669_D);
        ItemStack goldStack = new ItemStack(Item.field_77717_p);
        ItemStack ironStack = new ItemStack(Item.field_77703_o);
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)m_itemPaddle, 1), (Object[])new Object[]{" xx", " xx", "x  ", Character.valueOf('x'), stickStack});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)m_itemMagicBucket, 1), (Object[])new Object[]{"   ", "x x", " x ", Character.valueOf('x'), goldStack});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)m_blockHelm, 1), (Object[])new Object[]{" x ", "x x", "yxy", Character.valueOf('x'), stickStack, Character.valueOf('y'), ironStack});
    }

    private void loadPropulsion() {
        PropulsionDiscovererRegistry.addDiscoverer(new SailDiscoverer());
    }
}

