/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cuchaz.ships.ShipGeometry;
import java.util.TreeSet;
import net.minecraft.util.ChunkCoordinates;
import org.junit.Assert;
import org.junit.Test;

public class TestShipGeometry {
    @Test
    public void singleBlockOuterBoudaries() {
        ShipGeometry geometry = new ShipGeometry(this.getBlocks(0, 0, 0));
        Assert.assertEquals((long)6L, (long)geometry.getOuterBoundaries().size());
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(-1, 0, 0)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(1, 0, 0)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(0, -1, 0)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(0, 1, 0)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(0, 0, -1)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(0, 0, 1)));
        Assert.assertEquals((long)0L, (long)geometry.getHoles().size());
        Assert.assertEquals((long)0L, (long)geometry.getTrappedAir(0).size());
        Assert.assertEquals((long)0L, (long)geometry.getTrappedAir(1).size());
    }

    @Test
    public void singleBlockHole() {
        ShipGeometry geometry = new ShipGeometry(this.getBlocks(0, 0, 0, 0, 0, 1, 0, 0, 2, 1, 0, 0, 1, 0, 1, 1, 0, 2, 2, 0, 0, 2, 0, 1, 2, 0, 2, 0, 1, 0, 0, 1, 1, 0, 1, 2, 1, 1, 0, 1, 1, 2, 2, 1, 0, 2, 1, 1, 2, 1, 2, 0, 2, 0, 0, 2, 1, 0, 2, 2, 1, 2, 0, 1, 2, 1, 1, 2, 2, 2, 2, 0, 2, 2, 1, 2, 2, 2));
        Assert.assertEquals((long)6L, (long)geometry.getOuterBoundaries().size());
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(0, -1, 0, 0, -1, 1, 0, -1, 2, 1, -1, 0, 1, -1, 1, 1, -1, 2, 2, -1, 0, 2, -1, 1, 2, -1, 2)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(0, 3, 0, 0, 3, 1, 0, 3, 2, 1, 3, 0, 1, 3, 1, 1, 3, 2, 2, 3, 0, 2, 3, 1, 2, 3, 2)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(3, 0, 0, 3, 0, 1, 3, 0, 2, 3, 1, 0, 3, 1, 1, 3, 1, 2, 3, 2, 0, 3, 2, 1, 3, 2, 2)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(-1, 0, 0, -1, 0, 1, -1, 0, 2, -1, 1, 0, -1, 1, 1, -1, 1, 2, -1, 2, 0, -1, 2, 1, -1, 2, 2)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(0, 0, 3, 1, 0, 3, 2, 0, 3, 0, 1, 3, 1, 1, 3, 2, 1, 3, 0, 2, 3, 1, 2, 3, 2, 2, 3)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(0, 0, -1, 1, 0, -1, 2, 0, -1, 0, 1, -1, 1, 1, -1, 2, 1, -1, 0, 2, -1, 1, 2, -1, 2, 2, -1)));
        Assert.assertEquals((long)1L, (long)geometry.getHoles().size());
        Assert.assertTrue((boolean)geometry.getHoles().contains(this.getBlocks(1, 1, 1)));
        Assert.assertEquals((long)0L, (long)geometry.getTrappedAir(0).size());
        Assert.assertEquals((long)1L, (long)geometry.getTrappedAir(1).size());
        Assert.assertEquals(this.getBlocks(1, 1, 1), geometry.getTrappedAir(1));
        Assert.assertEquals((long)1L, (long)geometry.getTrappedAir(2).size());
        Assert.assertEquals(this.getBlocks(1, 1, 1), geometry.getTrappedAir(2));
        Assert.assertEquals((long)1L, (long)geometry.getTrappedAir(3).size());
        Assert.assertEquals(this.getBlocks(1, 1, 1), geometry.getTrappedAir(3));
    }

    @Test
    public void threeByThreeByThreeHole() {
        ShipGeometry geometry = new ShipGeometry(this.getBlocks(0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 0, 3, 0, 0, 4, 1, 0, 0, 1, 0, 1, 1, 0, 2, 1, 0, 3, 1, 0, 4, 2, 0, 0, 2, 0, 1, 2, 0, 2, 2, 0, 3, 2, 0, 4, 3, 0, 0, 3, 0, 1, 3, 0, 2, 3, 0, 3, 3, 0, 4, 4, 0, 0, 4, 0, 1, 4, 0, 2, 4, 0, 3, 4, 0, 4, 0, 1, 0, 0, 1, 1, 0, 1, 2, 0, 1, 3, 0, 1, 4, 1, 1, 0, 1, 1, 4, 2, 1, 0, 2, 1, 4, 3, 1, 0, 3, 1, 4, 4, 1, 0, 4, 1, 1, 4, 1, 2, 4, 1, 3, 4, 1, 4, 0, 2, 0, 0, 2, 1, 0, 2, 2, 0, 2, 3, 0, 2, 4, 1, 2, 0, 1, 2, 4, 2, 2, 0, 2, 2, 4, 3, 2, 0, 3, 2, 4, 4, 2, 0, 4, 2, 1, 4, 2, 2, 4, 2, 3, 4, 2, 4, 0, 3, 0, 0, 3, 1, 0, 3, 2, 0, 3, 3, 0, 3, 4, 1, 3, 0, 1, 3, 4, 2, 3, 0, 2, 3, 4, 3, 3, 0, 3, 3, 4, 4, 3, 0, 4, 3, 1, 4, 3, 2, 4, 3, 3, 4, 3, 4, 0, 4, 0, 0, 4, 1, 0, 4, 2, 0, 4, 3, 0, 4, 4, 1, 4, 0, 1, 4, 1, 1, 4, 2, 1, 4, 3, 1, 4, 4, 2, 4, 0, 2, 4, 1, 2, 4, 2, 2, 4, 3, 2, 4, 4, 3, 4, 0, 3, 4, 1, 3, 4, 2, 3, 4, 3, 3, 4, 4, 4, 4, 0, 4, 4, 1, 4, 4, 2, 4, 4, 3, 4, 4, 4));
        Assert.assertEquals((long)1L, (long)geometry.getHoles().size());
        Assert.assertTrue((boolean)geometry.getHoles().contains(this.getBlocks(1, 1, 1, 1, 1, 2, 1, 1, 3, 2, 1, 1, 2, 1, 2, 2, 1, 3, 3, 1, 1, 3, 1, 2, 3, 1, 3, 1, 2, 1, 1, 2, 2, 1, 2, 3, 2, 2, 1, 2, 2, 2, 2, 2, 3, 3, 2, 1, 3, 2, 2, 3, 2, 3, 1, 3, 1, 1, 3, 2, 1, 3, 3, 2, 3, 1, 2, 3, 2, 2, 3, 3, 3, 3, 1, 3, 3, 2, 3, 3, 3)));
        Assert.assertEquals((long)0L, (long)geometry.getTrappedAir(0).size());
        Assert.assertEquals((long)9L, (long)geometry.getTrappedAir(1).size());
        Assert.assertEquals(this.getBlocks(1, 1, 1, 1, 1, 2, 1, 1, 3, 2, 1, 1, 2, 1, 2, 2, 1, 3, 3, 1, 1, 3, 1, 2, 3, 1, 3), geometry.getTrappedAir(1));
        Assert.assertEquals((long)18L, (long)geometry.getTrappedAir(2).size());
        Assert.assertEquals(this.getBlocks(1, 1, 1, 1, 1, 2, 1, 1, 3, 2, 1, 1, 2, 1, 2, 2, 1, 3, 3, 1, 1, 3, 1, 2, 3, 1, 3, 1, 2, 1, 1, 2, 2, 1, 2, 3, 2, 2, 1, 2, 2, 2, 2, 2, 3, 3, 2, 1, 3, 2, 2, 3, 2, 3), geometry.getTrappedAir(2));
        Assert.assertEquals((long)27L, (long)geometry.getTrappedAir(3).size());
        Assert.assertEquals(this.getBlocks(1, 1, 1, 1, 1, 2, 1, 1, 3, 2, 1, 1, 2, 1, 2, 2, 1, 3, 3, 1, 1, 3, 1, 2, 3, 1, 3, 1, 2, 1, 1, 2, 2, 1, 2, 3, 2, 2, 1, 2, 2, 2, 2, 2, 3, 3, 2, 1, 3, 2, 2, 3, 2, 3, 1, 3, 1, 1, 3, 2, 1, 3, 3, 2, 3, 1, 2, 3, 2, 2, 3, 3, 3, 3, 1, 3, 3, 2, 3, 3, 3), geometry.getTrappedAir(3));
        Assert.assertEquals((long)27L, (long)geometry.getTrappedAir(4).size());
        Assert.assertEquals(this.getBlocks(1, 1, 1, 1, 1, 2, 1, 1, 3, 2, 1, 1, 2, 1, 2, 2, 1, 3, 3, 1, 1, 3, 1, 2, 3, 1, 3, 1, 2, 1, 1, 2, 2, 1, 2, 3, 2, 2, 1, 2, 2, 2, 2, 2, 3, 3, 2, 1, 3, 2, 2, 3, 2, 3, 1, 3, 1, 1, 3, 2, 1, 3, 3, 2, 3, 1, 2, 3, 2, 2, 3, 3, 3, 3, 1, 3, 3, 2, 3, 3, 3), geometry.getTrappedAir(4));
        Assert.assertEquals((long)27L, (long)geometry.getTrappedAir(5).size());
        Assert.assertEquals(this.getBlocks(1, 1, 1, 1, 1, 2, 1, 1, 3, 2, 1, 1, 2, 1, 2, 2, 1, 3, 3, 1, 1, 3, 1, 2, 3, 1, 3, 1, 2, 1, 1, 2, 2, 1, 2, 3, 2, 2, 1, 2, 2, 2, 2, 2, 3, 3, 2, 1, 3, 2, 2, 3, 2, 3, 1, 3, 1, 1, 3, 2, 1, 3, 3, 2, 3, 1, 2, 3, 2, 2, 3, 3, 3, 3, 1, 3, 3, 2, 3, 3, 3), geometry.getTrappedAir(5));
    }

    @Test
    public void singleBlockHull() {
        ShipGeometry geometry = new ShipGeometry(this.getBlocks(0, 0, 0, 0, 0, 1, 0, 0, 2, 1, 0, 0, 1, 0, 1, 1, 0, 2, 2, 0, 0, 2, 0, 1, 2, 0, 2, 0, 1, 0, 0, 1, 1, 0, 1, 2, 1, 1, 0, 1, 1, 2, 2, 1, 0, 2, 1, 1, 2, 1, 2));
        Assert.assertEquals((long)7L, (long)geometry.getOuterBoundaries().size());
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(0, -1, 0, 0, -1, 1, 0, -1, 2, 1, -1, 0, 1, -1, 1, 1, -1, 2, 2, -1, 0, 2, -1, 1, 2, -1, 2)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(1, 1, 1)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(0, 2, 0, 0, 2, 1, 0, 2, 2, 1, 2, 0, 1, 2, 2, 2, 2, 0, 2, 2, 1, 2, 2, 2)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(3, 0, 0, 3, 0, 1, 3, 0, 2, 3, 1, 0, 3, 1, 1, 3, 1, 2)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(-1, 0, 0, -1, 0, 1, -1, 0, 2, -1, 1, 0, -1, 1, 1, -1, 1, 2)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(0, 0, 3, 1, 0, 3, 2, 0, 3, 0, 1, 3, 1, 1, 3, 2, 1, 3)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(0, 0, -1, 1, 0, -1, 2, 0, -1, 0, 1, -1, 1, 1, -1, 2, 1, -1)));
        Assert.assertEquals((long)0L, (long)geometry.getHoles().size());
        Assert.assertEquals((long)0L, (long)geometry.getTrappedAir(0).size());
        Assert.assertEquals((long)1L, (long)geometry.getTrappedAir(1).size());
        Assert.assertEquals(this.getBlocks(1, 1, 1), geometry.getTrappedAir(1));
        Assert.assertEquals((long)0L, (long)geometry.getTrappedAir(2).size());
    }

    @Test
    public void twoLevelHull() {
        ShipGeometry geometry = new ShipGeometry(this.getBlocks(0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 0, 3, 0, 0, 4, 1, 0, 0, 1, 0, 1, 1, 0, 2, 1, 0, 3, 1, 0, 4, 2, 0, 0, 2, 0, 1, 2, 0, 2, 2, 0, 3, 2, 0, 4, 3, 0, 0, 3, 0, 1, 3, 0, 2, 3, 0, 3, 3, 0, 4, 0, 1, 0, 0, 1, 1, 0, 1, 2, 0, 1, 3, 0, 1, 4, 1, 1, 0, 1, 1, 3, 1, 1, 4, 2, 1, 0, 2, 1, 3, 2, 1, 4, 3, 1, 0, 3, 1, 1, 3, 1, 2, 3, 1, 3, 3, 1, 4, 0, 2, 0, 0, 2, 1, 0, 2, 2, 0, 2, 3, 0, 2, 4, 1, 2, 0, 1, 2, 4, 2, 2, 0, 2, 2, 4, 3, 2, 0, 3, 2, 1, 3, 2, 2, 3, 2, 3, 3, 2, 4));
        Assert.assertEquals((long)7L, (long)geometry.getOuterBoundaries().size());
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(0, -1, 0, 0, -1, 1, 0, -1, 2, 0, -1, 3, 0, -1, 4, 1, -1, 0, 1, -1, 1, 1, -1, 2, 1, -1, 3, 1, -1, 4, 2, -1, 0, 2, -1, 1, 2, -1, 2, 2, -1, 3, 2, -1, 4, 3, -1, 0, 3, -1, 1, 3, -1, 2, 3, -1, 3, 3, -1, 4)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(0, 0, -1, 1, 0, -1, 2, 0, -1, 3, 0, -1, 0, 1, -1, 1, 1, -1, 2, 1, -1, 3, 1, -1, 0, 2, -1, 1, 2, -1, 2, 2, -1, 3, 2, -1)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(0, 0, 5, 1, 0, 5, 2, 0, 5, 3, 0, 5, 0, 1, 5, 1, 1, 5, 2, 1, 5, 3, 1, 5, 0, 2, 5, 1, 2, 5, 2, 2, 5, 3, 2, 5)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(-1, 0, 0, -1, 0, 1, -1, 0, 2, -1, 0, 3, -1, 0, 4, -1, 1, 0, -1, 1, 1, -1, 1, 2, -1, 1, 3, -1, 1, 4, -1, 2, 0, -1, 2, 1, -1, 2, 2, -1, 2, 3, -1, 2, 4)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(4, 0, 0, 4, 0, 1, 4, 0, 2, 4, 0, 3, 4, 0, 4, 4, 1, 0, 4, 1, 1, 4, 1, 2, 4, 1, 3, 4, 1, 4, 4, 2, 0, 4, 2, 1, 4, 2, 2, 4, 2, 3, 4, 2, 4)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(1, 1, 1, 1, 1, 2, 2, 1, 1, 2, 1, 2, 1, 2, 1, 1, 2, 2, 1, 2, 3, 2, 2, 1, 2, 2, 2, 2, 2, 3)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(0, 3, 0, 0, 3, 1, 0, 3, 2, 0, 3, 3, 0, 3, 4, 1, 3, 0, 1, 3, 4, 2, 3, 0, 2, 3, 4, 3, 3, 0, 3, 3, 1, 3, 3, 2, 3, 3, 3, 3, 3, 4)));
        Assert.assertEquals((long)0L, (long)geometry.getHoles().size());
        Assert.assertEquals((long)0L, (long)geometry.getTrappedAir(0).size());
        Assert.assertEquals((long)4L, (long)geometry.getTrappedAir(1).size());
        Assert.assertEquals(this.getBlocks(1, 1, 1, 1, 1, 2, 2, 1, 1, 2, 1, 2), geometry.getTrappedAir(1));
        Assert.assertEquals((long)10L, (long)geometry.getTrappedAir(2).size());
        Assert.assertEquals(this.getBlocks(1, 1, 1, 1, 1, 2, 2, 1, 1, 2, 1, 2, 1, 2, 1, 1, 2, 2, 1, 2, 3, 2, 2, 1, 2, 2, 2, 2, 2, 3), geometry.getTrappedAir(2));
        Assert.assertEquals((long)0L, (long)geometry.getTrappedAir(3).size());
    }

    @Test
    public void singleBlockHullEdgeNeighbors() {
        ShipGeometry geometry = new ShipGeometry(this.getBlocks(1, 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 2, 2, 1, 1));
        Assert.assertEquals((long)18L, (long)geometry.getOuterBoundaries().size());
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(1, -1, 1)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(0, 0, 1)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(1, 0, 0)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(1, 0, 2)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(2, 0, 1)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(-1, 1, 1)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(0, 1, 0)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(0, 1, 2)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(1, 1, -1)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(1, 1, 1)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(1, 1, 3)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(2, 1, 0)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(2, 1, 2)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(3, 1, 1)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(0, 2, 1)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(1, 2, 0)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(1, 2, 2)));
        Assert.assertTrue((boolean)geometry.getOuterBoundaries().contains(this.getBlocks(2, 2, 1)));
        Assert.assertEquals((long)0L, (long)geometry.getHoles().size());
        Assert.assertEquals((long)0L, (long)geometry.getTrappedAir(0).size());
        Assert.assertEquals((long)1L, (long)geometry.getTrappedAir(1).size());
        Assert.assertEquals(this.getBlocks(1, 1, 1), geometry.getTrappedAir(1));
        Assert.assertEquals((long)0L, (long)geometry.getTrappedAir(2).size());
    }

    private TreeSet<ChunkCoordinates> getBlocks(int ... coords) {
        if (coords.length % 3 != 0) {
            throw new IllegalArgumentException("Need coordinates in multiples of three!");
        }
        TreeSet<ChunkCoordinates> blocks = new TreeSet<ChunkCoordinates>();
        int numCoords = coords.length / 3;
        int i = 0;
        while (i < numCoords) {
            blocks.add(new ChunkCoordinates(coords[i * 3 + 0], coords[i * 3 + 1], coords[i * 3 + 2]));
            ++i;
        }
        return blocks;
    }
}

