/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.asm;

import cuchaz.ships.Ships;
import java.io.IOException;
import java.util.logging.Level;
import org.objectweb.asm.ClassReader;

public class InheritanceUtils {
    public static boolean extendsClass(String className, String targetClassName) {
        if (className.equalsIgnoreCase(targetClassName)) {
            return true;
        }
        if (className.startsWith("[")) {
            return false;
        }
        try {
            ClassReader classReader = new ClassReader(className.replace('.', '/'));
            String superClassName = classReader.getSuperName();
            if (superClassName != null) {
                return InheritanceUtils.extendsClass(superClassName, targetClassName);
            }
        }
        catch (IOException ex) {
            Ships.logger.log(Level.WARNING, "Unable to read class: " + className, ex);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean implementsInterface(String interfaceName, String targetInterfaceName) {
        if (interfaceName.equalsIgnoreCase(targetInterfaceName)) {
            return true;
        }
        String className = interfaceName.replace('.', '/');
        try {
            ClassReader classReader = new ClassReader(className);
            String[] stringArray = classReader.getInterfaces();
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String i = stringArray[n2];
                if (InheritanceUtils.implementsInterface(i, targetInterfaceName)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (IOException ex) {
            Ships.logger.log(Level.WARNING, "Unable to read class: " + className, ex);
        }
        return false;
    }
}

