/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.asm;

import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import java.lang.reflect.Field;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;

public class ObfuscationAwareAdapter
extends ClassVisitor {
    private boolean m_isObfuscatedEnvironment;

    public ObfuscationAwareAdapter(int api, ClassVisitor cv, boolean isObfuscatedEnvironment) {
        super(api, cv);
        this.m_isObfuscatedEnvironment = isObfuscatedEnvironment;
    }

    protected String getRuntimeClassName(String clearClassName) {
        if (this.m_isObfuscatedEnvironment) {
            return this.getObfuscatedClassName(clearClassName);
        }
        return clearClassName;
    }

    protected String getRuntimeMethodName(String runtimeClassName, String clearMethodName, String idMethodName) {
        if (this.m_isObfuscatedEnvironment) {
            return this.methodMapReverseLookup(this.getMethodMap(runtimeClassName), idMethodName);
        }
        return clearMethodName;
    }

    private String getObfuscatedClassName(String clearClassName) {
        String obfuscatedClassName = FMLDeobfuscatingRemapper.INSTANCE.unmap(clearClassName);
        if (obfuscatedClassName == null) {
            obfuscatedClassName = clearClassName;
        }
        return obfuscatedClassName;
    }

    private Map<String, String> getMethodMap(String obfuscatedClassName) {
        try {
            Field field = FMLDeobfuscatingRemapper.class.getDeclaredField("methodNameMaps");
            field.setAccessible(true);
            return (Map)((Map)field.get(FMLDeobfuscatingRemapper.INSTANCE)).get(obfuscatedClassName);
        }
        catch (Exception ex) {
            throw new Error("Unable to access FML's deobfuscation mappings!", ex);
        }
    }

    private String methodMapReverseLookup(Map<String, String> methodMap, String idMethodName) {
        if (methodMap == null) {
            return idMethodName;
        }
        for (Map.Entry<String, String> entry : methodMap.entrySet()) {
            if (!entry.getValue().equals(idMethodName)) continue;
            String obfuscatedName = entry.getKey();
            return obfuscatedName.substring(0, obfuscatedName.indexOf("("));
        }
        return "";
    }
}

