/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.asm;

import cuchaz.modsShared.RuntimeMapping;
import cuchaz.ships.EntityShip;
import cuchaz.ships.ShipLocator;
import cuchaz.ships.ShipWorld;
import cuchaz.ships.Ships;
import java.lang.reflect.Field;
import java.util.logging.Level;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class ShipIntermediary {
    public static final String Path = "cuchaz/ships/asm/ShipIntermediary";

    public static World translateWorld(World world, InventoryPlayer inventory) {
        EntityShip ship = ShipLocator.getFromPlayerLook(inventory.field_70458_d);
        if (ship != null) {
            return ship.getBlocks();
        }
        return world;
    }

    public static double getEntityDistanceSq(EntityPlayer player, double tileEntityX, double tileEntityY, double tileEntityZ, TileEntity tileEntity) {
        return ShipIntermediary.translateDistance(tileEntity.field_70331_k, player, tileEntityX, tileEntityY, tileEntityZ);
    }

    public static double getEntityDistanceSq(EntityPlayer player, double containerX, double containerY, double containerZ, Container container) {
        World world = null;
        int x = 0;
        int y = 0;
        int z = 0;
        try {
            Field fieldWorld = ShipIntermediary.getField(container, RuntimeMapping.getRuntimeName("worldObj", "field_75161_g"), RuntimeMapping.getRuntimeName("worldPointer", "field_75172_h"), RuntimeMapping.getRuntimeName("theWorld", "field_82860_h"));
            world = (World)fieldWorld.get(container);
            Field fieldX = ShipIntermediary.getField(container, RuntimeMapping.getRuntimeName("posX", "field_75164_h"), RuntimeMapping.getRuntimeName("posX", "field_75173_i"), RuntimeMapping.getRuntimeName("field_82861_i", "field_82861_i"));
            x = fieldX.getInt(container);
            Field fieldY = ShipIntermediary.getField(container, RuntimeMapping.getRuntimeName("posY", "field_75165_i"), RuntimeMapping.getRuntimeName("posY", "field_75170_j"), RuntimeMapping.getRuntimeName("field_82858_j", "field_82858_j"));
            y = fieldY.getInt(container);
            Field fieldZ = ShipIntermediary.getField(container, RuntimeMapping.getRuntimeName("posZ", "field_75163_j"), RuntimeMapping.getRuntimeName("posZ", "field_75171_k"), RuntimeMapping.getRuntimeName("field_82859_k", "field_82859_k"));
            z = fieldZ.getInt(container);
        }
        catch (Exception ex) {
            Ships.logger.log(Level.WARNING, "Unable to reflect on container class: " + container.getClass().getName(), ex);
        }
        return ShipIntermediary.translateDistance(world, player, x, y, z);
    }

    public static void onEntityMove(Entity entity, double dx, double dy, double dz) {
        double oldX = entity.field_70165_t;
        double oldY = entity.field_70163_u;
        double oldZ = entity.field_70161_v;
        double oldYSize = entity.field_70139_V;
        entity.func_70091_d(dx, dy, dz);
        if (!entity.field_70145_X) {
            for (EntityShip ship : ShipLocator.getFromEntityLocation(entity)) {
                ship.getCollider().onNearbyEntityMoved(oldX, oldY, oldZ, oldYSize, entity);
            }
        }
    }

    private static double translateDistance(World world, EntityPlayer player, double x, double y, double z) {
        if (world != null && world instanceof ShipWorld) {
            EntityShip ship = ((ShipWorld)world).getShip();
            Vec3 v = Vec3.func_72443_a((double)x, (double)y, (double)z);
            ship.blocksToShip(v);
            ship.shipToWorld(v);
            return player.func_70092_e(v.field_72450_a, v.field_72448_b, v.field_72449_c);
        }
        return player.func_70092_e(x, y, z);
    }

    private static Field getField(Object obj, String ... names) {
        Field[] fieldArray = obj.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            String[] stringArray = names;
            int n3 = names.length;
            int n4 = 0;
            while (n4 < n3) {
                String name = stringArray[n4];
                if (field.getName().equals(name)) {
                    field.setAccessible(true);
                    return field;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }
}

