/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.asm;

import cuchaz.ships.asm.InheritanceUtils;
import cuchaz.ships.asm.ObfuscationAwareAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class TileEntityInventoryAdapter
extends ObfuscationAwareAdapter {
    private final String InventoryInterfaceName = this.getRuntimeClassName("net/minecraft/inventory/IInventory");
    private final String TileEntityClassName = this.getRuntimeClassName("net/minecraft/tileentity/TileEntity");
    private final String ContainerClassName = this.getRuntimeClassName("net/minecraft/inventory/Container");
    private final String PlayerClassName = this.getRuntimeClassName("net/minecraft/entity/player/EntityPlayer");
    private final String InventoryPlayerClassName = this.getRuntimeClassName("net/minecraft/entity/player/InventoryPlayer");
    private final String WorldClassName = this.getRuntimeClassName("net/minecraft/world/World");
    private String m_name;
    private String m_superName;
    private String[] m_interfaces;

    public TileEntityInventoryAdapter(int api, ClassVisitor cv, boolean isObfuscatedEnvironment) {
        super(api, cv, isObfuscatedEnvironment);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.m_name = name;
        this.m_superName = superName;
        this.m_interfaces = interfaces;
    }

    public MethodVisitor visitMethod(int access, String methodName, String methodDesc, String signature, String[] exceptions) {
        boolean isContainerCanInteractWith;
        final boolean isTileEntityInventoryIsUseableByPlayer = methodName.equals(this.getRuntimeMethodName(this.m_name, "isUseableByPlayer", "func_70300_a")) && this.extendsClass(this.TileEntityClassName) && this.implementsInterface(this.InventoryInterfaceName);
        boolean bl = isContainerCanInteractWith = methodName.equals(this.getRuntimeMethodName(this.m_name, "canInteractWith", "func_75145_c")) && this.extendsClass(this.ContainerClassName);
        if ((isTileEntityInventoryIsUseableByPlayer || isContainerCanInteractWith) && methodDesc.equals(String.format("(L%s;)Z", this.PlayerClassName))) {
            return new MethodVisitor(this.api, this.cv.visitMethod(access, methodName, methodDesc, signature, exceptions)){

                public void visitMethodInsn(int opcode, String calledOwner, String calledName, String calledDesc) {
                    if (opcode == 182 && calledDesc.equals("(DDD)D") && calledOwner.equals(TileEntityInventoryAdapter.this.PlayerClassName) && calledName.equals(TileEntityInventoryAdapter.this.getRuntimeMethodName(calledOwner, "getDistanceSq", "func_70092_e"))) {
                        String thisType = null;
                        if (isTileEntityInventoryIsUseableByPlayer) {
                            thisType = TileEntityInventoryAdapter.this.TileEntityClassName;
                        } else if (isContainerCanInteractWith) {
                            thisType = TileEntityInventoryAdapter.this.ContainerClassName;
                        } else {
                            throw new Error("Unable to determine this type!");
                        }
                        this.mv.visitVarInsn(25, 0);
                        this.mv.visitMethodInsn(184, "cuchaz/ships/asm/ShipIntermediary", "getEntityDistanceSq", String.format("(L%s;DDDL%s;)D", TileEntityInventoryAdapter.this.PlayerClassName, thisType));
                    } else {
                        super.visitMethodInsn(opcode, calledOwner, calledName, calledDesc);
                    }
                }
            };
        }
        if (methodName.equals("<init>") && methodDesc.equals(String.format("(L%s;L%s;III)V", this.InventoryPlayerClassName, this.WorldClassName)) && this.extendsClass(this.ContainerClassName)) {
            return new MethodVisitor(this.api, this.cv.visitMethod(access, methodName, methodDesc, signature, exceptions)){

                public void visitFieldInsn(int opcode, String owner, String fieldName, String desc) {
                    if (opcode == 181 && desc.equals(String.format("L%s;", TileEntityInventoryAdapter.this.WorldClassName)) && owner.equals(TileEntityInventoryAdapter.this.m_name)) {
                        this.mv.visitVarInsn(25, 1);
                        this.mv.visitMethodInsn(184, "cuchaz/ships/asm/ShipIntermediary", "translateWorld", String.format("(L%s;L%s;)L%s;", TileEntityInventoryAdapter.this.WorldClassName, TileEntityInventoryAdapter.this.InventoryPlayerClassName, TileEntityInventoryAdapter.this.WorldClassName));
                        this.mv.visitFieldInsn(181, owner, fieldName, desc);
                    } else {
                        super.visitFieldInsn(opcode, owner, fieldName, desc);
                    }
                }
            };
        }
        return super.visitMethod(access, methodName, methodDesc, signature, exceptions);
    }

    private boolean extendsClass(String targetClassName) {
        return InheritanceUtils.extendsClass(this.m_superName, targetClassName);
    }

    private boolean implementsInterface(String targetInterfaceName) {
        String[] stringArray = this.m_interfaces;
        int n = this.m_interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            String i = stringArray[n2];
            if (InheritanceUtils.implementsInterface(i, targetInterfaceName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

