/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cuchaz.ships.ContainerShip;
import cuchaz.ships.EntityShip;
import cuchaz.ships.ShipLauncher;
import cuchaz.ships.ShipLocator;
import cuchaz.ships.Ships;
import cuchaz.ships.gui.GuiShipLaunch;
import cuchaz.ships.gui.GuiShipPilotPaddle;
import cuchaz.ships.gui.GuiShipPilotSurface;
import cuchaz.ships.gui.GuiShipPropulsion;
import cuchaz.ships.gui.GuiShipUnlaunch;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.world.World;

public enum Gui {
    BuildShip{

        @Override
        @SideOnly(value=Side.CLIENT)
        public GuiContainer getGui(EntityPlayer player, World world, int x, int y, int z) {
            return new GuiShipLaunch(new ContainerShip(), new ShipLauncher(world, x, y, z));
        }
    }
    ,
    UnbuildShip{

        @Override
        @SideOnly(value=Side.CLIENT)
        public GuiContainer getGuiOnShip(EntityPlayer player, EntityShip ship) {
            return new GuiShipUnlaunch(new ContainerShip(), ship);
        }
    }
    ,
    PaddleShip{

        @Override
        @SideOnly(value=Side.CLIENT)
        public GuiContainer getGuiOnShip(EntityPlayer player, EntityShip ship) {
            return new GuiShipPilotPaddle(new ContainerShip(), ship, player);
        }
    }
    ,
    PilotSurfaceShip{

        @Override
        @SideOnly(value=Side.CLIENT)
        public GuiContainer getGuiOnShip(EntityPlayer player, EntityShip ship) {
            return new GuiShipPilotSurface(new ContainerShip(), ship, player);
        }
    }
    ,
    ShipPropulsion{

        @Override
        @SideOnly(value=Side.CLIENT)
        public GuiContainer getGui(EntityPlayer player, World world, int x, int y, int z) {
            return new GuiShipPropulsion(new ContainerShip(), world, x, y, z);
        }
    };


    private Gui() {
    }

    public void open(EntityPlayer player, World world, int x, int y, int z) {
        player.openGui((Object)Ships.instance, this.ordinal(), world, x, y, z);
    }

    public Container getContainer(EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerShip();
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(EntityPlayer player, World world, int x, int y, int z) {
        EntityShip ship = ShipLocator.getFromPlayerLook(player);
        if (ship == null) {
            Ships.logger.warning("Unable to locate ship!");
            return null;
        }
        return this.getGuiOnShip(player, ship);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGuiOnShip(EntityPlayer player, EntityShip ship) {
        return null;
    }

    /* synthetic */ Gui(String string, int n, Gui gui) {
        this();
    }
}

