/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.gui;

import cuchaz.modsShared.BlockSide;
import cuchaz.modsShared.ColorUtils;
import cuchaz.ships.EntityShip;
import cuchaz.ships.PilotAction;
import cuchaz.ships.gui.GuiCloseable;
import java.util.List;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public abstract class GuiShipPilot
extends GuiCloseable {
    private static final ResourceLocation BackgroundTexture = new ResourceLocation("ships", "textures/gui/shipPaddle.png");
    private static final int TextureWidth = 128;
    private static final int TextureHeight = 32;
    private EntityShip m_ship;
    private List<PilotAction> m_allowedActions;
    private int m_lastActions;
    private BlockSide m_forwardSide;

    public GuiShipPilot(Container container, EntityShip ship, EntityPlayer player, List<PilotAction> allowedActions, ForwardSideMethod forwardSideMethod) {
        super(container);
        this.m_ship = ship;
        this.m_allowedActions = allowedActions;
        this.m_lastActions = 0;
        this.m_forwardSide = forwardSideMethod.compute(ship, player);
    }

    protected EntityShip getShip() {
        return this.m_ship;
    }

    protected BlockSide getForwardSide() {
        return this.m_forwardSide;
    }

    public void func_73866_w_() {
        this.field_74198_m = (this.field_73880_f - this.field_74194_b) / 2;
        this.field_74197_n = this.field_73881_g - this.field_74195_c - 48;
        this.field_73885_j = true;
        this.field_73882_e.field_71415_G = true;
        this.field_73882_e.field_71417_B.func_74372_a();
        PilotAction.setActionCodes(this.field_73882_e.field_71474_y);
    }

    protected void func_74189_g(int mouseX, int mouseY) {
        int keyForward = this.field_73882_e.field_71474_y.field_74351_w.field_74512_d;
        int keyBack = this.field_73882_e.field_71474_y.field_74368_y.field_74512_d;
        int keyLeft = this.field_73882_e.field_71474_y.field_74370_x.field_74512_d;
        int keyRight = this.field_73882_e.field_71474_y.field_74366_z.field_74512_d;
        int textColor = ColorUtils.getGrey(64);
        this.field_73886_k.func_78276_b(Keyboard.getKeyName((int)keyForward), 11, 8, textColor);
        this.field_73886_k.func_78276_b(Keyboard.getKeyName((int)keyBack), 46, 8, textColor);
        this.field_73886_k.func_78276_b(Keyboard.getKeyName((int)keyLeft), 61, 8, textColor);
        this.field_73886_k.func_78276_b(Keyboard.getKeyName((int)keyRight), 95, 8, textColor);
    }

    protected void func_74185_a(float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.func_110434_K().func_110577_a(BackgroundTexture);
        double umax = (double)this.field_74194_b / 128.0;
        double vmax = (double)this.field_74195_c / 32.0;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)this.field_74198_m, (double)(this.field_74197_n + this.field_74195_c), (double)this.field_73735_i, 0.0, vmax);
        tessellator.func_78374_a((double)(this.field_74198_m + this.field_74194_b), (double)(this.field_74197_n + this.field_74195_c), (double)this.field_73735_i, umax, vmax);
        tessellator.func_78374_a((double)(this.field_74198_m + this.field_74194_b), (double)this.field_74197_n, (double)this.field_73735_i, umax, 0.0);
        tessellator.func_78374_a((double)this.field_74198_m, (double)this.field_74197_n, (double)this.field_73735_i, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    public void func_73873_v_() {
    }

    public void func_73876_c() {
        int actions = PilotAction.getActiveActions(this.field_73882_e.field_71474_y, this.m_allowedActions);
        if (actions != this.m_lastActions) {
            this.applyActions(actions);
        }
        this.m_lastActions = actions;
    }

    protected void func_73864_a(int x, int y, int button) {
        if (button == 1) {
            this.close();
        }
    }

    public void func_73874_b() {
        this.applyActions(0);
    }

    private void applyActions(int actions) {
        this.m_ship.setPilotActions(actions, this.m_forwardSide, true);
    }

    protected static enum ForwardSideMethod {
        ByPlayerLook{

            @Override
            public BlockSide compute(EntityShip ship, EntityPlayer player) {
                Vec3 blockCenter = Vec3.func_72443_a((double)0.5, (double)0.5, (double)0.5);
                ship.blocksToShip(blockCenter);
                ship.shipToWorld(blockCenter);
                Vec3 direction = Vec3.func_72443_a((double)(player.field_70165_t - blockCenter.field_72450_a), (double)0.0, (double)(player.field_70161_v - blockCenter.field_72449_c));
                ship.worldToShipDirection(direction);
                double maxDot = Double.NEGATIVE_INFINITY;
                BlockSide sideShipForward = null;
                BlockSide[] blockSideArray = BlockSide.xzSides();
                int n = blockSideArray.length;
                int n2 = 0;
                while (n2 < n) {
                    BlockSide side = blockSideArray[n2];
                    double dot = (double)(-side.getDx()) * direction.field_72450_a + (double)(-side.getDz()) * direction.field_72449_c;
                    if (dot > maxDot) {
                        maxDot = dot;
                        sideShipForward = side;
                    }
                    ++n2;
                }
                return sideShipForward;
            }
        }
        ,
        ByHelm{

            @Override
            public BlockSide compute(EntityShip ship, EntityPlayer player) {
                return ship.getPropulsion().getFrontSide();
            }
        };


        public abstract BlockSide compute(EntityShip var1, EntityPlayer var2);
    }
}

