/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.gui;

import cuchaz.modsShared.CircleRange;
import cuchaz.modsShared.ColorUtils;
import cuchaz.ships.EntityShip;
import cuchaz.ships.PilotAction;
import cuchaz.ships.gui.GuiShipPilot;
import java.util.Arrays;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiShipPilotSurface
extends GuiShipPilot {
    private static final ResourceLocation BackgroundTexture = new ResourceLocation("ships", "textures/gui/shipPilotSurface.png");
    private static final int TextureWidth = 256;
    private static final int TextureHeight = 64;
    private static final int CompassHeight = 12;
    private static final int CompassY = 52;
    private static final int CompassFrameX = 156;
    private static final int CompassFrameY = 6;
    private static final int CompassFrameWidth = 93;
    private static final int CompassNorthOffset = 5;
    private static final int CompassMarkerX = 201;
    private static final int CompassMarkerY = 31;
    private static final int CompassMarkerWidth = 3;
    private static final int CompassMarkerHeight = 4;
    private static final int CompassRangeX = 8;
    private static final int CompassRangeY = 39;
    private static final int CompassRangeWidth = 16;
    private static final int ThrottleX = 8;
    private static final int ThrottleY = 26;
    private static final int ThrottleZero = 12;
    private static final int ThrottleWidth = 37;
    private static final int ThrottleHeight = 12;
    private static final int ThrottleFrameX = 8;
    private static final int ThrottleFrameY = 6;

    public GuiShipPilotSurface(Container container, EntityShip ship, EntityPlayer player) {
        super(container, ship, player, Arrays.asList(PilotAction.ThrottleUp, PilotAction.ThrottleDown, PilotAction.Left, PilotAction.Right), GuiShipPilot.ForwardSideMethod.ByHelm);
        this.field_74194_b = 256;
        this.field_74195_c = 25;
    }

    @Override
    protected void func_74189_g(int mouseX, int mouseY) {
        int keyForward = this.field_73882_e.field_71474_y.field_74351_w.field_74512_d;
        int keyBack = this.field_73882_e.field_71474_y.field_74368_y.field_74512_d;
        int keyLeft = this.field_73882_e.field_71474_y.field_74370_x.field_74512_d;
        int keyRight = this.field_73882_e.field_71474_y.field_74366_z.field_74512_d;
        int textColor = ColorUtils.getGrey(64);
        int TextOffset = 44;
        this.field_73886_k.func_78276_b(Keyboard.getKeyName((int)keyForward), 55, 8, textColor);
        this.field_73886_k.func_78276_b(Keyboard.getKeyName((int)keyBack), 90, 8, textColor);
        this.field_73886_k.func_78276_b(Keyboard.getKeyName((int)keyLeft), 105, 8, textColor);
        this.field_73886_k.func_78276_b(Keyboard.getKeyName((int)keyRight), 139, 8, textColor);
        this.loadTexture();
        double shipDirectionOffset = (double)this.getForwardSide().getXZOffset() / 4.0;
        double shipYawOffset = CircleRange.mapZeroTo360(this.getShip().field_70177_z) / 360.0f;
        double compassFrameOffset = 0.181640625;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        double z = this.field_73735_i;
        double umin = 0.01953125 + shipDirectionOffset - shipYawOffset - compassFrameOffset;
        double umax = umin + 0.36328125;
        double vmin = 0.8125;
        double vmax = 1.0;
        double x = 156.0;
        double y = 6.0;
        tessellator.func_78374_a(x, y + 12.0, z, umin, vmax);
        tessellator.func_78374_a(x + 93.0, y + 12.0, z, umax, vmax);
        tessellator.func_78374_a(x + 93.0, y, z, umax, vmin);
        tessellator.func_78374_a(x, y, z, umin, vmin);
        umin = 0.0625 - shipYawOffset - compassFrameOffset;
        umax = umin + 0.36328125;
        vmin = 0.609375;
        vmax = vmin + 0.1875;
        x = 156.0;
        y = 6.0;
        tessellator.func_78374_a(x, y + 12.0, z, umin, vmax);
        tessellator.func_78374_a(x + 93.0, y + 12.0, z, umax, vmax);
        tessellator.func_78374_a(x + 93.0, y, z, umax, vmin);
        tessellator.func_78374_a(x, y, z, umin, vmin);
        umin = 0.78515625;
        umax = umin + 0.01171875;
        vmin = 0.484375;
        vmax = vmin + 0.0625;
        x = 201.0;
        y = 4.0;
        tessellator.func_78374_a(x, y + 4.0, z, umin, vmax);
        tessellator.func_78374_a(x + 3.0, y + 4.0, z, umax, vmax);
        tessellator.func_78374_a(x + 3.0, y, z, umax, vmin);
        tessellator.func_78374_a(x, y, z, umin, vmin);
        if (this.getShip().linearThrottle > 0) {
            double fullWidth = 32.0;
            double throttleWidth = fullWidth * (double)this.getShip().linearThrottle / 100.0;
            umin = 0.05078125;
            umax = umin + throttleWidth / 256.0;
            vmin = 0.40625;
            vmax = vmin + 0.1875;
            x = 13.0;
            y = 6.0;
            tessellator.func_78374_a(x, y + 12.0, z, umin, vmax);
            tessellator.func_78374_a(x + throttleWidth, y + 12.0, z, umax, vmax);
            tessellator.func_78374_a(x + throttleWidth, y, z, umax, vmin);
            tessellator.func_78374_a(x, y, z, umin, vmin);
        } else if (this.getShip().linearThrottle < 0) {
            double fullWidth = 4.0;
            double throttleWidth = fullWidth * (double)this.getShip().linearThrottle / -25.0;
            umax = 0.04296875;
            umin = umax - (throttleWidth - 1.0) / 256.0;
            vmin = 0.40625;
            vmax = vmin + 0.1875;
            x = 8.0 + fullWidth - throttleWidth;
            y = 6.0;
            tessellator.func_78374_a(x, y + 12.0, z, umin, vmax);
            tessellator.func_78374_a(x + throttleWidth, y + 12.0, z, umax, vmax);
            tessellator.func_78374_a(x + throttleWidth, y, z, umax, vmin);
            tessellator.func_78374_a(x, y, z, umin, vmin);
        }
        tessellator.func_78381_a();
    }

    @Override
    protected void func_74185_a(float f, int i, int j) {
        this.loadTexture();
        double umax = (double)this.field_74194_b / 256.0;
        double vmax = (double)this.field_74195_c / 64.0;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)this.field_74198_m, (double)(this.field_74197_n + this.field_74195_c), (double)this.field_73735_i, 0.0, vmax);
        tessellator.func_78374_a((double)(this.field_74198_m + this.field_74194_b), (double)(this.field_74197_n + this.field_74195_c), (double)this.field_73735_i, umax, vmax);
        tessellator.func_78374_a((double)(this.field_74198_m + this.field_74194_b), (double)this.field_74197_n, (double)this.field_73735_i, umax, 0.0);
        tessellator.func_78374_a((double)this.field_74198_m, (double)this.field_74197_n, (double)this.field_73735_i, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    private void loadTexture() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.func_110434_K().func_110577_a(BackgroundTexture);
    }
}

