/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.gui;

import cuchaz.modsShared.BlockArray;
import cuchaz.modsShared.BlockSide;
import cuchaz.modsShared.BlockUtils;
import cuchaz.modsShared.ColorUtils;
import cuchaz.ships.MaterialProperties;
import cuchaz.ships.ShipLauncher;
import cuchaz.ships.Ships;
import cuchaz.ships.gui.GuiShip;
import cuchaz.ships.gui.GuiString;
import cuchaz.ships.propulsion.Propulsion;
import cuchaz.ships.render.RenderShip2D;
import cuchaz.ships.render.ShaderLoader;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.inventory.Container;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL20;

public class GuiShipPropulsion
extends GuiShip {
    private static final ResourceLocation DesaturationShader = new ResourceLocation("ships", "shaders/desaturate.frag");
    private ShipLauncher m_shipLauncher = null;
    private Propulsion m_propulsion;
    private BlockArray m_shipEnvelope = null;
    private BlockArray m_helmEnvelope = null;
    private BlockArray m_propulsionEnvelope = null;
    private int m_desaturationProgramId = 0;
    private double m_topLinearSpeed = 0.0;
    private float m_topAngularSpeed = 0.0f;
    private String m_propulsionMethodsDescription;

    public GuiShipPropulsion(Container container, final World world, int helmX, int helmY, int helmZ) {
        super(container);
        assert (world.func_72798_a(helmX, helmY, helmZ) == Ships.m_blockHelm.field_71990_ca);
        ChunkCoordinates helmCoords = new ChunkCoordinates(helmX, helmY, helmZ);
        ChunkCoordinates shipBlockCoords = BlockUtils.searchForBlock(helmX, helmY, helmZ, 10000, new BlockUtils.BlockConditionValidator(){

            @Override
            public boolean isValid(ChunkCoordinates coords) {
                return !MaterialProperties.isSeparatorBlock(Block.field_71973_m[world.func_72798_a(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c)]);
            }

            @Override
            public boolean isConditionMet(ChunkCoordinates coords) {
                return world.func_72798_a(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c) == Ships.m_blockShip.field_71990_ca;
            }
        }, BlockUtils.Neighbors.Edges);
        if (shipBlockCoords == null) {
            return;
        }
        this.m_shipLauncher = new ShipLauncher(world, shipBlockCoords.field_71574_a, shipBlockCoords.field_71572_b, shipBlockCoords.field_71573_c);
        if (this.m_shipLauncher.getShipWorld() == null) {
            return;
        }
        if (this.m_shipLauncher.getShipType().isPaddleable()) {
            return;
        }
        this.m_shipEnvelope = this.m_shipLauncher.getShipEnvelope(BlockSide.Top);
        helmCoords.field_71574_a -= shipBlockCoords.field_71574_a;
        helmCoords.field_71572_b -= shipBlockCoords.field_71572_b;
        helmCoords.field_71573_c -= shipBlockCoords.field_71573_c;
        this.m_helmEnvelope = this.m_shipEnvelope.newEmptyCopy();
        this.m_helmEnvelope.setBlock(helmCoords.field_71574_a, helmCoords.field_71573_c, helmCoords);
        this.m_propulsion = new Propulsion(this.m_shipLauncher.getShipWorld());
        this.m_propulsionEnvelope = this.m_propulsion.getEnevelope();
        try {
            this.m_desaturationProgramId = ShaderLoader.createProgram(ShaderLoader.load(DesaturationShader));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.m_topLinearSpeed = this.m_shipLauncher.getShipPhysics().getTopLinearSpeed(this.m_propulsion, this.m_shipLauncher.getShipWorld().getGeometry().getEnvelopes());
        this.m_topAngularSpeed = this.m_shipLauncher.getShipPhysics().getTopAngularSpeed(this.m_propulsion);
        StringBuilder buf = new StringBuilder();
        buf.append("Found ");
        String delimiter = "";
        for (Propulsion.MethodCount count : this.m_propulsion.methodCounts()) {
            buf.append(delimiter);
            buf.append(count.toString());
            delimiter = ", ";
        }
        if (delimiter == "") {
            buf.append("no propulsion methods!");
        }
        this.m_propulsionMethodsDescription = buf.toString();
    }

    protected void func_74189_g(int mouseX, int mouseY) {
        this.drawHeaderText(GuiString.ShipPropulsion.getLocalizedText(), 0);
        if (this.m_shipLauncher == null) {
            this.drawText(GuiString.NoShipBlock.getLocalizedText(), 1);
        } else if (this.m_propulsion == null) {
            this.drawText(GuiString.InvalidShip.getLocalizedText(), 1);
        } else {
            this.drawLabelValueText("Ship Mass", String.format("%.1f Kg", this.m_shipLauncher.getShipPhysics().getMass()), 1);
            this.drawLabelValueText("Thrust", String.format("%.1f N", this.m_propulsion.getTotalThrust()), 2);
            this.drawLabelValueText("Top Speed", String.format("%.1f m/s", this.m_topLinearSpeed * 20.0), 3);
            this.drawLabelValueText("Turning Speed", String.format("%.1f deg/sec", Float.valueOf(this.m_topAngularSpeed)), 4);
            this.drawPropulsion();
            this.drawText(this.m_propulsionMethodsDescription, 12);
        }
    }

    private void drawPropulsion() {
        int x = 8;
        int y = this.getLineY(6);
        int width = this.field_74194_b - 16;
        int height = 64;
        RenderShip2D.drawWater(x, y, this.field_73735_i, width, height);
        if (this.m_shipEnvelope.getHeight() > this.m_shipEnvelope.getWidth()) {
            this.m_shipEnvelope = BlockArray.Rotation.Ccw90.rotate(this.m_shipEnvelope);
            this.m_helmEnvelope = BlockArray.Rotation.Ccw90.rotate(this.m_helmEnvelope);
            this.m_propulsionEnvelope = BlockArray.Rotation.Ccw90.rotate(this.m_propulsionEnvelope);
        }
        RenderShip2D.drawShipAsColor(this.m_shipEnvelope, ColorUtils.getGrey(64), x, y, this.field_73735_i, width, height);
        GL20.glUseProgram((int)this.m_desaturationProgramId);
        RenderShip2D.drawShip(this.m_shipEnvelope, this.m_shipLauncher.getShipWorld(), x, y, this.field_73735_i, width, height);
        GL20.glUseProgram((int)0);
        RenderShip2D.drawShip(this.m_propulsionEnvelope, this.m_shipLauncher.getShipWorld(), x, y, this.field_73735_i, width, height);
        RenderShip2D.drawShip(this.m_helmEnvelope, this.m_shipLauncher.getShipWorld(), x, y, this.field_73735_i, width, height);
    }
}

