/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.packets;

import cuchaz.ships.EntityShip;
import cuchaz.ships.ShipWorld;
import cuchaz.ships.packets.Packet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.TreeSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChunkCoordinates;

public class PacketChangedBlocks
extends Packet {
    public static final String Channel = "changedBlocks";
    private TreeSet<ChunkCoordinates> m_changedBlocks;
    private EntityShip m_ship;
    private int m_entityId;
    private int m_numChangedBlocks;
    private int[] m_x;
    private int[] m_y;
    private int[] m_z;
    private int[] m_blockId;
    private int[] m_meta;

    public PacketChangedBlocks() {
        super(Channel);
    }

    public PacketChangedBlocks(EntityShip ship, TreeSet<ChunkCoordinates> changedBlocks) {
        this();
        this.m_changedBlocks = changedBlocks;
        this.m_ship = ship;
    }

    @Override
    public void writeData(DataOutputStream out) throws IOException {
        ShipWorld world = this.m_ship.getBlocks();
        out.writeInt(this.m_ship.field_70157_k);
        out.writeInt(this.m_changedBlocks.size());
        for (ChunkCoordinates coords : this.m_changedBlocks) {
            out.writeShort(coords.field_71574_a);
            out.writeShort(coords.field_71572_b);
            out.writeShort(coords.field_71573_c);
            out.writeShort(world.getBlockId(coords));
            out.writeByte(world.getBlockMetadata(coords));
        }
    }

    @Override
    public void readData(DataInputStream in) throws IOException {
        this.m_entityId = in.readInt();
        this.m_numChangedBlocks = in.readInt();
        this.m_x = new int[this.m_numChangedBlocks];
        this.m_y = new int[this.m_numChangedBlocks];
        this.m_z = new int[this.m_numChangedBlocks];
        this.m_blockId = new int[this.m_numChangedBlocks];
        this.m_meta = new int[this.m_numChangedBlocks];
        int i = 0;
        while (i < this.m_numChangedBlocks) {
            this.m_x[i] = in.readShort();
            this.m_y[i] = in.readShort();
            this.m_z[i] = in.readShort();
            this.m_blockId[i] = in.readShort();
            this.m_meta[i] = in.readByte();
            ++i;
        }
    }

    @Override
    public void onPacketReceived(EntityPlayer player) {
        EntityShip ship = (EntityShip)player.field_70170_p.func_73045_a(this.m_entityId);
        if (ship == null) {
            return;
        }
        ShipWorld world = ship.getBlocks();
        int i = 0;
        while (i < this.m_numChangedBlocks) {
            world.applyBlockChange(this.m_x[i], this.m_y[i], this.m_z[i], this.m_blockId[i], this.m_meta[i]);
            ++i;
        }
    }
}

