/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.packets;

import cuchaz.ships.ShipLauncher;
import cuchaz.ships.Ships;
import cuchaz.ships.packets.Packet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;

public class PacketLaunchShip
extends Packet {
    public static final String Channel = "launchShip";
    private int m_x;
    private int m_y;
    private int m_z;

    public PacketLaunchShip() {
        super(Channel);
    }

    public PacketLaunchShip(int x, int y, int z) {
        this();
        this.m_x = x;
        this.m_y = y;
        this.m_z = z;
    }

    @Override
    public void writeData(DataOutputStream out) throws IOException {
        out.writeInt(this.m_x);
        out.writeInt(this.m_y);
        out.writeInt(this.m_z);
    }

    @Override
    public void readData(DataInputStream in) throws IOException {
        this.m_x = in.readInt();
        this.m_y = in.readInt();
        this.m_z = in.readInt();
    }

    @Override
    public void onPacketReceived(EntityPlayer player) {
        ShipLauncher launcher = new ShipLauncher(player.field_70170_p, this.m_x, this.m_y, this.m_z);
        if (launcher.isLaunchable()) {
            launcher.launch();
        } else {
            Ships.logger.warning(String.format("Server can't launch ship at: (%d,%d,%d)", this.m_x, this.m_y, this.m_z));
            ShipLauncher.LaunchFlag[] launchFlagArray = ShipLauncher.LaunchFlag.values();
            int n = launchFlagArray.length;
            int n2 = 0;
            while (n2 < n) {
                ShipLauncher.LaunchFlag flag = launchFlagArray[n2];
                Ships.logger.warning("\t" + flag.name() + ": " + launcher.getLaunchFlag(flag));
                ++n2;
            }
        }
    }
}

