/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.packets;

import cpw.mods.fml.common.network.PacketDispatcher;
import cuchaz.modsShared.BlockSide;
import cuchaz.ships.EntityShip;
import cuchaz.ships.packets.Packet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public class PacketPilotShip
extends Packet {
    public static final String Channel = "pilotShip";
    private int m_entityId;
    private int m_actions;
    private BlockSide m_sideShipForward;
    private int m_linearThrottle;
    private int m_angularThrottle;

    public PacketPilotShip() {
        super(Channel);
    }

    public PacketPilotShip(int entityId, int actions, BlockSide sideFacingPlayer, int linearThrottle, int angularThrottle) {
        this();
        this.m_entityId = entityId;
        this.m_actions = actions;
        this.m_sideShipForward = sideFacingPlayer;
        this.m_linearThrottle = linearThrottle;
        this.m_angularThrottle = angularThrottle;
    }

    @Override
    public void writeData(DataOutputStream out) throws IOException {
        out.writeInt(this.m_entityId);
        out.writeInt(this.m_actions);
        out.writeByte(this.m_sideShipForward.ordinal());
        out.writeByte(this.m_linearThrottle);
        out.writeByte(this.m_angularThrottle);
    }

    @Override
    public void readData(DataInputStream in) throws IOException {
        this.m_entityId = in.readInt();
        this.m_actions = in.readInt();
        this.m_sideShipForward = BlockSide.values()[in.readByte()];
        this.m_linearThrottle = in.readByte();
        this.m_angularThrottle = in.readByte();
    }

    @Override
    public void onPacketReceived(EntityPlayer player) {
        Entity entity = player.field_70170_p.func_73045_a(this.m_entityId);
        if (entity == null || !(entity instanceof EntityShip)) {
            return;
        }
        EntityShip ship = (EntityShip)entity;
        ship.setPilotActions(this.m_actions, this.m_sideShipForward, false);
        ship.linearThrottle = this.m_linearThrottle;
        ship.angularThrottle = this.m_angularThrottle;
        if (!player.field_70170_p.field_72995_K) {
            double BroadcastRange = 100.0;
            PacketDispatcher.sendPacketToAllAround((double)ship.field_70165_t, (double)ship.field_70163_u, (double)ship.field_70161_v, (double)100.0, (int)player.field_70170_p.field_73011_w.field_76574_g, (net.minecraft.network.packet.Packet)this.getCustomPacket());
        }
    }
}

