/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.packets;

import cuchaz.ships.EntityShip;
import cuchaz.ships.ShipWorld;
import cuchaz.ships.Ships;
import cuchaz.ships.packets.Packet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public class PacketShipBlocks
extends Packet {
    public static final String Channel = "shipBlocks";
    private int m_entityId;
    private byte[] m_blocksData;

    public PacketShipBlocks() {
        super(Channel);
    }

    public PacketShipBlocks(EntityShip ship) {
        this();
        this.m_entityId = ship.field_70157_k;
        this.m_blocksData = ship.getBlocks().getData();
    }

    @Override
    public void writeData(DataOutputStream out) throws IOException {
        out.writeInt(this.m_entityId);
        out.writeInt(this.m_blocksData.length);
        out.write(this.m_blocksData);
    }

    @Override
    public void readData(DataInputStream in) throws IOException {
        this.m_entityId = in.readInt();
        this.m_blocksData = new byte[in.readInt()];
        in.read(this.m_blocksData);
    }

    @Override
    public void onPacketReceived(EntityPlayer player) {
        Entity entity = player.field_70170_p.func_73045_a(this.m_entityId);
        if (entity == null || !(entity instanceof EntityShip)) {
            Ships.logger.warning(String.format("Client dropping PacketShipBlocks for client ship %d! Can't find the ship!", this.m_entityId));
            return;
        }
        EntityShip ship = (EntityShip)entity;
        ship.setBlocks(new ShipWorld(player.field_70170_p, this.m_blocksData));
    }
}

