/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.packets;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cuchaz.ships.EntityShip;
import cuchaz.ships.Ships;
import cuchaz.ships.packets.Packet;
import cuchaz.ships.packets.PacketShipBlocks;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public class PacketShipBlocksRequest
extends Packet {
    public static final String Channel = "shipBlocksRqst";
    private int m_entityId;

    public PacketShipBlocksRequest() {
        super(Channel);
    }

    public PacketShipBlocksRequest(EntityShip ship) {
        this();
        this.m_entityId = ship.field_70157_k;
    }

    @Override
    public void writeData(DataOutputStream out) throws IOException {
        out.writeInt(this.m_entityId);
    }

    @Override
    public void readData(DataInputStream in) throws IOException {
        this.m_entityId = in.readInt();
    }

    @Override
    public void onPacketReceived(EntityPlayer player) {
        Entity entity = player.field_70170_p.func_73045_a(this.m_entityId);
        if (entity == null || !(entity instanceof EntityShip)) {
            Ships.logger.warning(String.format("Server dropping PacketShipBlocksRequest from client ship %d! Can't find the ship!", this.m_entityId));
            return;
        }
        EntityShip ship = (EntityShip)entity;
        PacketDispatcher.sendPacketToPlayer((net.minecraft.network.packet.Packet)new PacketShipBlocks(ship).getCustomPacket(), (Player)((Player)player));
    }
}

