/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.propulsion;

import cuchaz.modsShared.BlockArray;
import cuchaz.modsShared.BlockSide;
import cuchaz.ships.ShipWorld;
import cuchaz.ships.Ships;
import cuchaz.ships.propulsion.Paddle;
import cuchaz.ships.propulsion.PropulsionDiscoverer;
import cuchaz.ships.propulsion.PropulsionDiscovererRegistry;
import cuchaz.ships.propulsion.PropulsionMethod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ChunkCoordinates;

public class Propulsion {
    private ShipWorld m_world;
    private ChunkCoordinates m_helmCoords;
    private BlockSide m_frontSide;
    private List<PropulsionMethod> m_methods;
    private Map<Class<? extends PropulsionMethod>, MethodCount> m_typeCounts;
    private double m_totalThrust;

    public Propulsion(ShipWorld world) {
        this.m_world = world;
        this.m_helmCoords = this.findHelm(this.m_world);
        this.m_methods = new ArrayList<PropulsionMethod>();
        if (world.getShipType().isPaddleable()) {
            this.m_methods.add(new Paddle());
        } else if (this.m_helmCoords != null) {
            this.m_frontSide = BlockSide.getByXZOffset(world.getBlockMetadata(this.m_helmCoords));
            for (PropulsionDiscoverer discoverer : PropulsionDiscovererRegistry.discoverers()) {
                this.m_methods.addAll(discoverer.getPropulsionMethods(this.m_world, this.m_frontSide));
            }
        }
        this.m_typeCounts = new HashMap<Class<? extends PropulsionMethod>, MethodCount>();
        for (PropulsionMethod method : this.m_methods) {
            MethodCount count = this.m_typeCounts.get(method.getClass());
            if (count == null) {
                count = new MethodCount(method);
                this.m_typeCounts.put(method.getClass(), count);
            }
            MethodCount methodCount = count;
            methodCount.m_numInstances = methodCount.m_numInstances + 1;
        }
        this.m_totalThrust = 0.0;
        for (PropulsionMethod method : this.m_methods) {
            this.m_totalThrust += method.getThrust();
        }
    }

    public BlockSide getFrontSide() {
        return this.m_frontSide;
    }

    public BlockArray getEnevelope() {
        BlockArray envelope = this.m_world.getGeometry().getEnvelopes().getEnvelope(BlockSide.Top).newEmptyCopy();
        for (PropulsionMethod method : this.m_methods) {
            for (ChunkCoordinates coords : method.getCoords()) {
                ChunkCoordinates oldCoords = envelope.getBlock(coords.field_71574_a, coords.field_71573_c);
                if (oldCoords != null && coords.field_71572_b <= oldCoords.field_71572_b) continue;
                envelope.setBlock(coords.field_71574_a, coords.field_71573_c, coords);
            }
        }
        return envelope;
    }

    public Iterable<PropulsionMethod> methods() {
        return this.m_methods;
    }

    public Iterable<MethodCount> methodCounts() {
        return this.m_typeCounts.values();
    }

    public double getTotalThrust() {
        return this.m_totalThrust;
    }

    private ChunkCoordinates findHelm(ShipWorld world) {
        for (ChunkCoordinates coords : world.coords()) {
            if (world.getBlockId(coords) != Ships.m_blockHelm.field_71990_ca) continue;
            return coords;
        }
        return null;
    }

    public static class MethodCount {
        private int m_numInstances = 0;
        private String m_name;
        private String m_namePlural;

        public MethodCount(PropulsionMethod method) {
            this.m_name = method.getName();
            this.m_namePlural = method.getNamePlural();
        }

        public String getName() {
            if (this.m_numInstances == 1) {
                return this.m_name;
            }
            return this.m_namePlural;
        }

        public String toString() {
            return String.format("%d %s", this.m_numInstances, this.getName());
        }
    }
}

