/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.propulsion;

import cuchaz.modsShared.BlockSide;
import cuchaz.ships.ShipWorld;
import cuchaz.ships.propulsion.PropulsionMethod;
import java.util.Set;
import net.minecraft.util.ChunkCoordinates;

public class Sail
extends PropulsionMethod {
    public static final double ThrustPerBlock = 0.2;
    private int m_numExposedBlocks;

    protected Sail(ShipWorld world, Set<ChunkCoordinates> coords, BlockSide frontDirection) {
        super("Sail", "Sails", coords);
        this.m_numExposedBlocks = this.getNumExposedBlocks(world, coords, frontDirection);
    }

    @Override
    public double getThrust() {
        return 0.2 * (double)this.m_numExposedBlocks;
    }

    public boolean isValid() {
        return this.m_numExposedBlocks >= this.getCoords().size() / 2;
    }

    private int getNumExposedBlocks(ShipWorld world, Set<ChunkCoordinates> blockCoords, BlockSide frontDirection) {
        int numExposedBlocks = 0;
        ChunkCoordinates neighborCoords = new ChunkCoordinates();
        BlockSide backDirection = frontDirection.getOppositeSide();
        for (ChunkCoordinates coords : blockCoords) {
            neighborCoords.func_71571_b(coords.field_71574_a + frontDirection.getDx(), coords.field_71572_b + frontDirection.getDy(), coords.field_71573_c + frontDirection.getDz());
            int frontId = world.getBlockId(neighborCoords);
            neighborCoords.func_71571_b(coords.field_71574_a + backDirection.getDx(), coords.field_71572_b + backDirection.getDy(), coords.field_71573_c + backDirection.getDz());
            int backId = world.getBlockId(neighborCoords);
            if (frontId != 0 || backId != 0) continue;
            ++numExposedBlocks;
        }
        return numExposedBlocks;
    }
}

