/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.propulsion;

import cuchaz.modsShared.BlockSide;
import cuchaz.modsShared.BlockUtils;
import cuchaz.ships.ShipWorld;
import cuchaz.ships.propulsion.PropulsionDiscoverer;
import cuchaz.ships.propulsion.PropulsionMethod;
import cuchaz.ships.propulsion.Sail;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.util.ChunkCoordinates;

public class SailDiscoverer
implements PropulsionDiscoverer {
    @Override
    public List<PropulsionMethod> getPropulsionMethods(ShipWorld world, BlockSide frontDirection) {
        TreeSet<ChunkCoordinates> clothCoords = new TreeSet<ChunkCoordinates>();
        for (ChunkCoordinates coords : world.coords()) {
            if (world.getBlockId(coords) != Block.field_72101_ab.field_71990_ca) continue;
            clothCoords.add(coords);
        }
        List<TreeSet<ChunkCoordinates>> clothComponents = BlockUtils.getConnectedComponents(clothCoords, BlockUtils.Neighbors.Edges);
        ArrayList<PropulsionMethod> sails = new ArrayList<PropulsionMethod>();
        for (TreeSet<ChunkCoordinates> component : clothComponents) {
            Sail sail = new Sail(world, component, frontDirection);
            if (!sail.isValid()) continue;
            sails.add(sail);
        }
        return sails;
    }
}

