/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.render;

import cuchaz.modsShared.BlockSide;
import cuchaz.modsShared.BoxCorner;
import cuchaz.modsShared.ColorUtils;
import cuchaz.modsShared.CompareReal;
import cuchaz.modsShared.Matrix3;
import cuchaz.modsShared.RotatedBB;
import cuchaz.modsShared.Vector3;
import cuchaz.ships.EntityShip;
import cuchaz.ships.ShipWorld;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class RenderShip
extends Render {
    private RenderBlocks m_renderBlocks = new RenderBlocks();

    protected ResourceLocation func_110775_a(Entity entity) {
        return null;
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float yaw, float partialTickTime) {
        this.doRender((EntityShip)entity, x, y, z, yaw, partialTickTime);
    }

    public void doRender(EntityShip ship, double x, double y, double z, float yaw, float partialTickTime) {
        this.m_renderBlocks.field_78669_a = ship.getBlocks();
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslated((double)ship.blocksToShipX(0.0), (double)ship.blocksToShipY(0.0), (double)ship.blocksToShipZ(0.0));
        RenderHelper.func_74518_a();
        RenderManager.field_78727_a.field_78724_e.func_110577_a(TextureMap.field_110575_b);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        ShipWorld world = ship.getBlocks();
        ArrayList<TileEntity> deferredTileEntities = new ArrayList<TileEntity>();
        for (ChunkCoordinates coords : ship.getBlocks().coords()) {
            Block block = Block.field_71973_m[world.getBlockId(coords)];
            block.func_71902_a((IBlockAccess)world, coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
            TileEntity tileEntity = world.getBlockTileEntity(coords);
            if (tileEntity != null && TileEntityRenderer.field_76963_a.func_76952_a(tileEntity)) {
                deferredTileEntities.add(tileEntity);
                continue;
            }
            if (block.func_71857_b() == 0) {
                int colorMultiplier = block.func_71920_b((IBlockAccess)world, coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
                float colorR = (float)(colorMultiplier >> 16 & 0xFF) / 255.0f;
                float colorG = (float)(colorMultiplier >> 8 & 0xFF) / 255.0f;
                float colorB = (float)(colorMultiplier & 0xFF) / 255.0f;
                this.m_renderBlocks.func_83018_a(block);
                this.m_renderBlocks.func_78609_c(block, coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, colorR, colorG, colorB);
                continue;
            }
            this.m_renderBlocks.func_78612_b(block, coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
        }
        tessellator.func_78381_a();
        for (TileEntity tileEntity : deferredTileEntities) {
            TileEntityRenderer.field_76963_a.func_76949_a(tileEntity, (double)tileEntity.field_70329_l, (double)tileEntity.field_70330_m, (double)tileEntity.field_70327_n, partialTickTime);
        }
        RenderHelper.func_74519_b();
        GL11.glPopMatrix();
    }

    public void func_76979_b(Entity entity, double x, double y, double z, float yaw, float partialTickTime) {
    }

    public static void renderPosition(Entity entity) {
        RenderShip.renderPoint(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, ColorUtils.getColor(0, 255, 0));
    }

    public static void renderPoint(double x, double y, double z, int color) {
        double Halfwidth = 0.05;
        RenderShip.renderBox(x - 0.05, x + 0.05, y - 0.05, y + 0.05, z - 0.05, z + 0.05, color);
    }

    public static void renderAxis(Entity entity) {
        double Halfwidth = 0.05;
        double HalfHeight = 2.0;
        RenderShip.renderBox(entity.field_70165_t - 0.05, entity.field_70165_t + 0.05, entity.field_70163_u - 2.0, entity.field_70163_u + 2.0, entity.field_70161_v - 0.05, entity.field_70161_v + 0.05, ColorUtils.getGrey(180));
    }

    public static void renderHitbox(RotatedBB box, int color) {
        double delta = 0.01;
        box.getAABox().field_72340_a -= 0.01;
        box.getAABox().field_72338_b -= 0.01;
        box.getAABox().field_72339_c -= 0.01;
        box.getAABox().field_72336_d += 0.01;
        box.getAABox().field_72337_e += 0.01;
        box.getAABox().field_72334_f += 0.01;
        RenderShip.renderRotatedBox(box, color);
        box.getAABox().field_72340_a += 0.01;
        box.getAABox().field_72338_b += 0.01;
        box.getAABox().field_72339_c += 0.01;
        box.getAABox().field_72336_d -= 0.01;
        box.getAABox().field_72337_e -= 0.01;
        box.getAABox().field_72334_f -= 0.01;
    }

    public static void renderHitbox(AxisAlignedBB box, int color) {
        double delta = 0.01;
        RenderShip.renderBox(box.field_72340_a - 0.01, box.field_72336_d + 0.01, box.field_72338_b - 0.01, box.field_72337_e + 0.01, box.field_72339_c - 0.01, box.field_72334_f + 0.01, color);
    }

    public static void renderBox(double xm, double xp, double ym, double yp, double zm, double zp, int color) {
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78384_a(color, 128);
        tessellator.func_78377_a(xm, yp, zm);
        tessellator.func_78377_a(xm, ym, zm);
        tessellator.func_78377_a(xp, ym, zm);
        tessellator.func_78377_a(xp, yp, zm);
        tessellator.func_78377_a(xp, yp, zp);
        tessellator.func_78377_a(xp, ym, zp);
        tessellator.func_78377_a(xm, ym, zp);
        tessellator.func_78377_a(xm, yp, zp);
        tessellator.func_78377_a(xp, yp, zm);
        tessellator.func_78377_a(xp, ym, zm);
        tessellator.func_78377_a(xp, ym, zp);
        tessellator.func_78377_a(xp, yp, zp);
        tessellator.func_78377_a(xm, yp, zp);
        tessellator.func_78377_a(xm, ym, zp);
        tessellator.func_78377_a(xm, ym, zm);
        tessellator.func_78377_a(xm, yp, zm);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
    }

    public static void renderRotatedBox(RotatedBB box, int color) {
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78384_a(color, 128);
        Vec3 p = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        for (BlockSide side : Arrays.asList(BlockSide.North, BlockSide.South, BlockSide.East, BlockSide.West)) {
            BoxCorner[] boxCornerArray = side.getCorners();
            int n = boxCornerArray.length;
            int n2 = 0;
            while (n2 < n) {
                BoxCorner corner = boxCornerArray[n2];
                box.getCorner(p, corner);
                tessellator.func_78377_a(p.field_72450_a, p.field_72448_b, p.field_72449_c);
                ++n2;
            }
        }
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
    }

    public static void renderVector(double x, double y, double z, double dx, double dy, double dz, int color) {
        Vector3 v = new Vector3(dx, dy, dz);
        if (CompareReal.eq(v.getSquaredLength(), 0.0)) {
            return;
        }
        double halfWidth = 0.2;
        Vector3[] vertices = new Vector3[]{new Vector3(halfWidth, halfWidth, 0.0), new Vector3(-halfWidth, halfWidth, 0.0), new Vector3(-halfWidth, -halfWidth, 0.0), new Vector3(halfWidth, -halfWidth, 0.0), new Vector3(0.0, 0.0, v.getLength())};
        v.normalize();
        Matrix3 basis = new Matrix3();
        Matrix3.getArbitraryBasisFromZ(basis, v);
        Vector3[] vector3Array = vertices;
        int n = vertices.length;
        int n2 = 0;
        while (n2 < n) {
            Vector3 p = vector3Array[n2];
            basis.multiply(p);
            p.x += x;
            p.y += y;
            p.z += z;
            ++n2;
        }
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78371_b(6);
        tessellator.func_78384_a(color, 128);
        tessellator.func_78377_a(vertices[4].x, vertices[4].y, vertices[4].z);
        tessellator.func_78377_a(vertices[0].x, vertices[0].y, vertices[0].z);
        tessellator.func_78377_a(vertices[1].x, vertices[1].y, vertices[1].z);
        tessellator.func_78377_a(vertices[2].x, vertices[2].y, vertices[2].z);
        tessellator.func_78377_a(vertices[3].x, vertices[3].y, vertices[3].z);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
    }
}

