/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.render;

import cuchaz.modsShared.BlockArray;
import cuchaz.modsShared.ColorUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class RenderShip2D {
    private static final int WaterColor = ColorUtils.getColor(43, 99, 225);
    private static final ResourceLocation ShipTexture = TextureMap.field_110575_b;

    public static void drawWater(BlockArray envelope, Double waterHeight, int x, int y, double z, int maxWidth, int maxHeight) {
        double blockSize = RenderShip2D.getBlockSize(maxWidth, maxHeight, envelope);
        double shipHeight = (double)envelope.getHeight() * blockSize;
        int waterRectHeight = maxHeight;
        if (waterHeight != null) {
            waterRectHeight = (int)((waterHeight - (double)envelope.getVMin()) * blockSize + ((double)maxHeight - shipHeight) / 2.0);
            waterRectHeight = Math.min(maxHeight, waterRectHeight);
        }
        RenderShip2D.drawWater(x, y + maxHeight - waterRectHeight, z, maxWidth, waterRectHeight);
    }

    public static void drawWater(int x, int y, double z, int maxWidth, int maxHeight) {
        RenderShip2D.drawColoredBlock(x, y, z, maxWidth, maxHeight, WaterColor);
    }

    public static void drawShip(BlockArray envelope, World world, int x, int y, double z, int maxWidth, int maxHeight) {
        double blockSize = RenderShip2D.getBlockSize(maxWidth, maxHeight, envelope);
        double shipWidth = (double)envelope.getWidth() * blockSize;
        double shipHeight = (double)envelope.getHeight() * blockSize;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ShipTexture);
        int u = envelope.getUMin();
        while (u <= envelope.getUMax()) {
            int v = envelope.getVMin();
            while (v <= envelope.getVMax()) {
                ChunkCoordinates coords = envelope.getBlock(u, v);
                if (coords != null) {
                    Block block = Block.field_71973_m[world.func_72798_a(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c)];
                    int meta = world.func_72805_g(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
                    Icon icon = block.func_71895_b((IBlockAccess)world, coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, meta);
                    RenderShip2D.drawTexturedBlock(((double)maxWidth - shipWidth) / 2.0 + (double)x + (double)envelope.toZeroBasedU(u) * blockSize, ((double)maxHeight - shipHeight) / 2.0 + (double)y + (double)(envelope.getHeight() - envelope.toZeroBasedV(v) - 1) * blockSize, z, blockSize, blockSize, icon);
                }
                ++v;
            }
            ++u;
        }
    }

    public static void drawShipAsColor(BlockArray envelope, int color, int x, int y, double z, int maxWidth, int maxHeight) {
        double blockSize = RenderShip2D.getBlockSize(maxWidth, maxHeight, envelope);
        double shipWidth = (double)envelope.getWidth() * blockSize;
        double shipHeight = (double)envelope.getHeight() * blockSize;
        int u = envelope.getUMin();
        while (u <= envelope.getUMax()) {
            int v = envelope.getVMin();
            while (v <= envelope.getVMax()) {
                ChunkCoordinates coords = envelope.getBlock(u, v);
                if (coords != null) {
                    RenderShip2D.drawColoredBlock(((double)maxWidth - shipWidth) / 2.0 + (double)x + (double)envelope.toZeroBasedU(u) * blockSize, ((double)maxHeight - shipHeight) / 2.0 + (double)y + (double)(envelope.getHeight() - envelope.toZeroBasedV(v) - 1) * blockSize, z, blockSize, blockSize, color);
                }
                ++v;
            }
            ++u;
        }
    }

    private static double getBlockSize(int maxWidth, int maxHeight, BlockArray envelope) {
        double blockSize = Math.min((double)maxWidth / (double)envelope.getWidth(), (double)maxHeight / (double)envelope.getHeight());
        return blockSize *= 0.8;
    }

    public static void drawColoredBlock(double x, double y, double z, double width, double height, int color) {
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)ColorUtils.getRedf(color), (float)ColorUtils.getGreenf(color), (float)ColorUtils.getBluef(color), (float)ColorUtils.getAlphaf(color));
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78377_a(x + 0.0, y + height, z);
        tessellator.func_78377_a(x + width, y + height, z);
        tessellator.func_78377_a(x + width, y + 0.0, z);
        tessellator.func_78377_a(x + 0.0, y + 0.0, z);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawTexturedBlock(double x, double y, double z, double width, double height, Icon icon) {
        double minU = icon.func_94214_a(0.0);
        double maxU = icon.func_94214_a(16.0);
        double minV = icon.func_94207_b(0.0);
        double maxV = icon.func_94207_b(16.0);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(x + 0.0, y + height, z, minU, maxV);
        tessellator.func_78374_a(x + width, y + height, z, maxU, maxV);
        tessellator.func_78374_a(x + width, y + 0.0, z, maxU, minV);
        tessellator.func_78374_a(x + 0.0, y + 0.0, z, minU, minV);
        tessellator.func_78381_a();
    }
}

