/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.render;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL20;

public class ShaderLoader {
    private static int BufferSize = 65536;
    private static HashMap<String, Integer> m_shaderTypes = new HashMap();

    static {
        m_shaderTypes.put("frag", 35632);
        m_shaderTypes.put("vert", 35633);
    }

    public static int load(ResourceLocation loc) throws IOException {
        int shaderId = GL20.glCreateShader((int)ShaderLoader.getShaderType(loc.func_110623_a()));
        GL20.glShaderSource((int)shaderId, (CharSequence)ShaderLoader.readResource(loc));
        GL20.glCompileShader((int)shaderId);
        return shaderId;
    }

    public static int createProgram(int shaderId) {
        int programId = GL20.glCreateProgram();
        GL20.glAttachShader((int)programId, (int)shaderId);
        GL20.glLinkProgram((int)programId);
        GL20.glValidateProgram((int)programId);
        return programId;
    }

    private static int getShaderType(String path) {
        String filename = new File(path).getName();
        String extension = filename.substring(filename.lastIndexOf(46) + 1);
        return m_shaderTypes.get(extension);
    }

    private static String readResource(ResourceLocation loc) throws IOException {
        int numBytesRead;
        InputStream in = Minecraft.func_71410_x().func_110442_L().func_110536_a(loc).func_110527_b();
        ByteArrayOutputStream out = new ByteArrayOutputStream(BufferSize);
        byte[] buf = new byte[BufferSize];
        while ((numBytesRead = in.read(buf)) != -1) {
            out.write(buf, 0, numBytesRead);
        }
        return new String(out.toByteArray(), "UTF-8");
    }
}

