/*
 * Decompiled with CFR 0.152.
 */
package com.kingrunes.somnia.asm;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class SClassTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (name.equalsIgnoreCase("cpw.mods.fml.common.FMLCommonHandler")) {
            return this.patchFMLCommonHandler(bytes);
        }
        if (name.equalsIgnoreCase("net.minecraft.world.WorldServer")) {
            return this.patchWorldServer(bytes, false);
        }
        if (name.equalsIgnoreCase("js")) {
            return this.patchWorldServer(bytes, true);
        }
        if (name.equalsIgnoreCase("net.minecraft.client.renderer.EntityRenderer")) {
            return this.patchEntityRenderer(bytes, false);
        }
        if (name.equalsIgnoreCase("bfe")) {
            return this.patchEntityRenderer(bytes, true);
        }
        if (name.equalsIgnoreCase("abw")) {
            return this.patchWorld(bytes);
        }
        return bytes;
    }

    private byte[] patchWorld(byte[] bytes) {
        String methodName = "a";
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals(methodName)) continue;
            m.access = 1;
            break;
        }
        ClassWriter cw = new ClassWriter(3);
        classNode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] patchEntityRenderer(byte[] bytes, boolean obf) {
        String methodName = obf ? "b" : "updateCameraAndRender";
        String methodName2 = obf ? "a" : "renderWorld";
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        boolean f = true;
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals(methodName) || !m.desc.equals("(F)V")) continue;
            for (AbstractInsnNode ain : m.instructions) {
                if (!(ain instanceof MethodInsnNode)) continue;
                MethodInsnNode min = (MethodInsnNode)ain;
                if (!min.name.equals(methodName2) || !min.desc.equalsIgnoreCase("(FJ)V") || min.getOpcode() != 182) continue;
                min.setOpcode(184);
                min.name = "renderWorld";
                min.owner = "com/kingrunes/somnia/Somnia";
                VarInsnNode vin = (VarInsnNode)m.instructions.get(m.instructions.indexOf((AbstractInsnNode)min) - (f ? 3 : 9));
                m.instructions.remove((AbstractInsnNode)vin);
                f = false;
            }
        }
        ClassWriter cw = new ClassWriter(3);
        classNode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] patchFMLCommonHandler(byte[] bytes) {
        String methodName = "onPostServerTick";
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals(methodName)) continue;
            AbstractInsnNode fain = m.instructions.getFirst();
            InsnList toInject = new InsnList();
            toInject.add((AbstractInsnNode)new FieldInsnNode(178, "com/kingrunes/somnia/Somnia", "instance", "Lcom/kingrunes/somnia/Somnia;"));
            toInject.add((AbstractInsnNode)new MethodInsnNode(182, "com/kingrunes/somnia/Somnia", "tick", "()V"));
            m.instructions.insertBefore(fain, toInject);
            break;
        }
        ClassWriter cw = new ClassWriter(3);
        classNode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] patchWorldServer(byte[] bytes, boolean obf) {
        String methodName = obf ? "b" : "tick";
        String methodName2 = obf ? "g" : "tickBlocksAndAmbiance";
        String methodName3 = obf ? "a" : "moodSoundAndLightCheck";
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            MethodInsnNode min;
            if (m.name.equals(methodName) && m.desc.equalsIgnoreCase("()V")) {
                for (AbstractInsnNode ain : m.instructions) {
                    if (!(ain instanceof LdcInsnNode)) continue;
                    LdcInsnNode lin = (LdcInsnNode)ain;
                    if (!lin.cst.equals("doMobSpawning")) continue;
                    int index = m.instructions.indexOf((AbstractInsnNode)lin);
                    m.instructions.remove(ain);
                    m.instructions.remove(m.instructions.get(index - 1));
                    min = (MethodInsnNode)m.instructions.get(index - 1);
                    min.setOpcode(184);
                    min.desc = "(Lnet/minecraft/world/WorldServer;)Z";
                    min.name = "doMobSpawning";
                    min.owner = "com/kingrunes/somnia/Somnia";
                }
                continue;
            }
            if (!m.name.equals(methodName2) || !m.desc.equalsIgnoreCase("()V")) continue;
            for (AbstractInsnNode ain : m.instructions) {
                if (!(ain instanceof MethodInsnNode)) continue;
                min = (MethodInsnNode)ain;
                if (!min.name.equals(methodName3) || !min.desc.startsWith("(IIL") || min.getOpcode() != 182) continue;
                min.setOpcode(184);
                min.name = "moodSoundAndLightCheck";
                min.owner = "com/kingrunes/somnia/Somnia";
                m.instructions.remove(m.instructions.get(m.instructions.indexOf((AbstractInsnNode)min) - 4));
            }
        }
        ClassWriter cw = new ClassWriter(3);
        classNode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }
}

