/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.api.vector;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import universalelectricity.api.vector.Rotation;
import universalelectricity.api.vector.Vector3;

public class Quaternion
implements Cloneable {
    public double x;
    public double y;
    public double z;
    public double s;
    public static final double SQRT2 = Math.sqrt(2.0);

    public Quaternion() {
        this.s = 1.0;
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Quaternion(Quaternion Quaternion2) {
        this.x = Quaternion2.x;
        this.y = Quaternion2.y;
        this.z = Quaternion2.z;
        this.s = Quaternion2.s;
    }

    public Quaternion(double d, double d1, double d2, double d3) {
        this.x = d1;
        this.y = d2;
        this.z = d3;
        this.s = d;
    }

    public Quaternion set(Quaternion Quaternion2) {
        this.x = Quaternion2.x;
        this.y = Quaternion2.y;
        this.z = Quaternion2.z;
        this.s = Quaternion2.s;
        return this;
    }

    public Quaternion set(double d, double d1, double d2, double d3) {
        this.x = d1;
        this.y = d2;
        this.z = d3;
        this.s = d;
        return this;
    }

    public static Quaternion aroundAxis(double ax, double ay, double az, double angle) {
        return new Quaternion().setAroundAxis(ax, ay, az, angle);
    }

    public static Quaternion aroundAxis(Vector3 axis, double angle) {
        return Quaternion.aroundAxis(axis.x, axis.y, axis.z, angle);
    }

    public Quaternion setAroundAxis(double ax, double ay, double az, double angle) {
        double d4 = Math.sin(angle *= 0.5);
        return this.set(Math.cos(angle), ax * d4, ay * d4, az * d4);
    }

    public Quaternion setAroundAxis(Vector3 axis, double angle) {
        return this.setAroundAxis(axis.x, axis.y, axis.z, angle);
    }

    public Quaternion multiply(Quaternion Quaternion2) {
        double d = this.s * Quaternion2.s - this.x * Quaternion2.x - this.y * Quaternion2.y - this.z * Quaternion2.z;
        double d1 = this.s * Quaternion2.x + this.x * Quaternion2.s - this.y * Quaternion2.z + this.z * Quaternion2.y;
        double d2 = this.s * Quaternion2.y + this.x * Quaternion2.z + this.y * Quaternion2.s - this.z * Quaternion2.x;
        double d3 = this.s * Quaternion2.z - this.x * Quaternion2.y + this.y * Quaternion2.x + this.z * Quaternion2.s;
        this.s = d;
        this.x = d1;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public Quaternion rightMultiply(Quaternion Quaternion2) {
        double d = this.s * Quaternion2.s - this.x * Quaternion2.x - this.y * Quaternion2.y - this.z * Quaternion2.z;
        double d1 = this.s * Quaternion2.x + this.x * Quaternion2.s + this.y * Quaternion2.z - this.z * Quaternion2.y;
        double d2 = this.s * Quaternion2.y - this.x * Quaternion2.z + this.y * Quaternion2.s + this.z * Quaternion2.x;
        double d3 = this.s * Quaternion2.z + this.x * Quaternion2.y - this.y * Quaternion2.x + this.z * Quaternion2.s;
        this.s = d;
        this.x = d1;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public double mag() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.s * this.s);
    }

    public Quaternion normalize() {
        double d = this.mag();
        if (d != 0.0) {
            d = 1.0 / d;
            this.x *= d;
            this.y *= d;
            this.z *= d;
            this.s *= d;
        }
        return this;
    }

    public Quaternion copy() {
        return new Quaternion(this);
    }

    public void rotate(Vector3 vec) {
        double d = -this.x * vec.x - this.y * vec.y - this.z * vec.z;
        double d1 = this.s * vec.x + this.y * vec.z - this.z * vec.y;
        double d2 = this.s * vec.y - this.x * vec.z + this.z * vec.x;
        double d3 = this.s * vec.z + this.x * vec.y - this.y * vec.x;
        vec.x = d1 * this.s - d * this.x - d2 * this.z + d3 * this.y;
        vec.y = d2 * this.s - d * this.y + d1 * this.z - d3 * this.x;
        vec.z = d3 * this.s - d * this.z - d1 * this.y + d2 * this.x;
    }

    public String toString() {
        MathContext cont = new MathContext(4, RoundingMode.HALF_UP);
        return "Quaternion[" + new BigDecimal(this.s, cont) + ", " + new BigDecimal(this.x, cont) + ", " + new BigDecimal(this.y, cont) + ", " + new BigDecimal(this.z, cont) + "]";
    }

    public Rotation rotation() {
        return new Rotation(this);
    }
}

