/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.compatibility;

import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.tile.IEnergyStorage;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.api.CompatibilityModule;
import universalelectricity.api.CompatibilityType;
import universalelectricity.api.vector.Vector3;

public class ModuleIndustrialCraft
extends CompatibilityModule {
    @Override
    public long doReceiveEnergy(Object handler, ForgeDirection direction, long energy, boolean doReceive) {
        if (handler instanceof IEnergySink) {
            long request = (long)Math.min(((IEnergySink)handler).demandedEnergyUnits() * (double)CompatibilityType.INDUSTRIALCRAFT.reciprocal_ratio, (double)energy);
            if (doReceive) {
                double rejected = ((IEnergySink)handler).injectEnergyUnits(direction, (float)request * CompatibilityType.INDUSTRIALCRAFT.ratio);
                return (long)Math.max((double)energy - rejected * (double)CompatibilityType.INDUSTRIALCRAFT.reciprocal_ratio, 0.0);
            }
            return request;
        }
        return 0L;
    }

    @Override
    public long doExtractEnergy(Object handler, ForgeDirection direction, long energy, boolean doExtract) {
        if (handler instanceof IEnergySource) {
            long demand = (long)Math.min(((IEnergySource)handler).getOfferedEnergy() * (double)CompatibilityType.INDUSTRIALCRAFT.reciprocal_ratio, (double)energy);
            if (doExtract) {
                ((IEnergySource)handler).drawEnergy((float)demand * CompatibilityType.INDUSTRIALCRAFT.ratio);
            }
            return demand;
        }
        return 0L;
    }

    @Override
    public boolean doIsHandler(Object obj) {
        return obj instanceof IEnergySink || obj instanceof IEnergySource || obj instanceof IElectricItem;
    }

    @Override
    public boolean doCanConnect(Object obj, ForgeDirection direction) {
        if (obj instanceof TileEntity) {
            TileEntity tileEntity = (TileEntity)obj;
            Vector3 adjacentCoordinate = new Vector3(tileEntity).modifyPositionFromSide(direction.getOpposite());
            if (tileEntity instanceof IEnergySink) {
                return ((IEnergySink)tileEntity).acceptsEnergyFrom(adjacentCoordinate.getTileEntity((IBlockAccess)tileEntity.field_70331_k), direction);
            }
            if (tileEntity instanceof IEnergySource) {
                return ((IEnergySource)tileEntity).emitsEnergyTo(adjacentCoordinate.getTileEntity((IBlockAccess)tileEntity.field_70331_k), direction);
            }
        }
        return false;
    }

    @Override
    public long doChargeItem(ItemStack itemStack, long joules, boolean docharge) {
        if (itemStack.func_77973_b() instanceof IElectricItem) {
            return (long)((float)ElectricItem.manager.charge(itemStack, (int)((float)joules * CompatibilityType.INDUSTRIALCRAFT.ratio), 4, true, false) * CompatibilityType.INDUSTRIALCRAFT.reciprocal_ratio);
        }
        return 0L;
    }

    @Override
    public long doDischargeItem(ItemStack itemStack, long joules, boolean doDischarge) {
        IElectricItem item;
        if (itemStack.func_77973_b() instanceof IElectricItem && (item = (IElectricItem)itemStack.func_77973_b()).canProvideEnergy(itemStack)) {
            return (long)((float)ElectricItem.manager.discharge(itemStack, (int)((float)joules * CompatibilityType.INDUSTRIALCRAFT.ratio), 4, true, doDischarge) * CompatibilityType.INDUSTRIALCRAFT.reciprocal_ratio);
        }
        return 0L;
    }

    @Override
    public ItemStack doGetItemWithCharge(ItemStack itemStack, long energy) {
        return null;
    }

    @Override
    public boolean doIsEnergyContainer(Object obj) {
        return obj instanceof IEnergyStorage;
    }

    @Override
    public long doGetEnergy(Object obj, ForgeDirection direction) {
        return (long)((float)((IEnergyStorage)obj).getStored() * CompatibilityType.INDUSTRIALCRAFT.reciprocal_ratio);
    }
}

