/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core;

import buildcraft.api.power.IPowerReceptor;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.IFMLCallHook;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import cpw.mods.fml.relauncher.Side;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.item.ISpecialElectricItem;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import net.minecraftforge.common.Configuration;
import universalelectricity.api.CompatibilityModule;
import universalelectricity.api.CompatibilityType;
import universalelectricity.api.energy.EnergyNetworkLoader;
import universalelectricity.compatibility.ModuleUniversalElectricity;
import universalelectricity.core.asm.TemplateInjectionManager;
import universalelectricity.core.asm.UniversalTransformer;
import universalelectricity.core.asm.template.item.TemplateICItem;
import universalelectricity.core.asm.template.item.TemplateTEItem;
import universalelectricity.core.asm.template.tile.TemplateBCTile;
import universalelectricity.core.asm.template.tile.TemplateICTile;
import universalelectricity.core.asm.template.tile.TemplateTETile;
import universalelectricity.core.net.EnergyNetwork;
import universalelectricity.core.net.NetworkTickHandler;

@Mod(modid="UniversalElectricity", version="3.0.0", name="Universal Electricity", dependencies="before:ForgeMultipart;before:BuildCraft|Energy")
@IFMLLoadingPlugin.TransformerExclusions(value={"universalelectricity.core.asm", "universalelectricity.core.asm.template"})
public class UELoader
implements IFMLLoadingPlugin,
IFMLCallHook {
    public static final String ID = "UniversalElectricity";
    public static final String NAME = "Universal Electricity";
    public static Configuration CONFIGURATION;
    @Mod.Metadata(value="UniversalElectricity")
    public static ModMetadata metadata;

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        CONFIGURATION = new Configuration(new File(Loader.instance().getConfigDir(), "UniversalElectricity.cfg"));
        CONFIGURATION.load();
        CompatibilityType.THERMAL_EXPANSION.ratio = (float)CONFIGURATION.get("Compatiblity", "Thermal Expansion Conversion Ratio", (double)CompatibilityType.THERMAL_EXPANSION.ratio).getDouble((double)CompatibilityType.THERMAL_EXPANSION.ratio);
        CompatibilityType.INDUSTRIALCRAFT.ratio = (float)CONFIGURATION.get("Compatiblity", "IndustrialCraft Conversion Ratio", (double)CompatibilityType.INDUSTRIALCRAFT.ratio).getDouble((double)CompatibilityType.INDUSTRIALCRAFT.ratio);
        CompatibilityType.BUILDCRAFT.ratio = (float)CONFIGURATION.get("Compatiblity", "BuildCraft Conversion Ratio", (double)CompatibilityType.BUILDCRAFT.ratio).getDouble((double)CompatibilityType.BUILDCRAFT.ratio);
        CompatibilityType.THERMAL_EXPANSION.reciprocal_ratio = 1.0f / CompatibilityType.THERMAL_EXPANSION.ratio;
        CompatibilityType.INDUSTRIALCRAFT.reciprocal_ratio = 1.0f / CompatibilityType.INDUSTRIALCRAFT.ratio;
        CompatibilityType.BUILDCRAFT.reciprocal_ratio = 1.0f / CompatibilityType.BUILDCRAFT.ratio;
        CompatibilityModule.register(new ModuleUniversalElectricity());
        for (CompatibilityType compatibility : CompatibilityType.values()) {
            compatibility.isModuleEnabled = CONFIGURATION.get("Compatiblity", "Load " + compatibility.moduleName + " Module", true).getBoolean(true);
            if (!compatibility.isModuleEnabled) continue;
            try {
                CompatibilityModule.register((CompatibilityModule)Class.forName("universalelectricity.compatibility.Module" + compatibility.moduleName).newInstance());
            }
            catch (Exception e) {
                System.out.println("[Universal Electricity] Failed to load module: " + compatibility.moduleName);
                e.printStackTrace();
            }
        }
        CONFIGURATION.save();
        TickRegistry.registerTickHandler((ITickHandler)NetworkTickHandler.INSTANCE, (Side)Side.SERVER);
        EnergyNetworkLoader.setNetworkClass(EnergyNetwork.class);
        UELoader.metadata.modId = ID;
        UELoader.metadata.name = NAME;
        UELoader.metadata.description = "Universal Electricity is a Minecraft modding library that provides an easy, flexible energy framework and compatibility bridges between various energy systems in Minecraft.";
        UELoader.metadata.url = "http://www.universalelectricity.com/";
        UELoader.metadata.version = "3.0.0.270";
        UELoader.metadata.authorList = Arrays.asList("Calclavia");
        UELoader.metadata.credits = "Please visit the website.";
        UELoader.metadata.autogenerated = false;
    }

    public String[] getASMTransformerClass() {
        return new String[]{UniversalTransformer.class.getName()};
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return UELoader.class.getName();
    }

    public void injectData(Map<String, Object> data) {
    }

    public String[] getLibraryRequestClass() {
        return null;
    }

    public Void call() throws Exception {
        TemplateInjectionManager.registerTileTemplate(CompatibilityType.THERMAL_EXPANSION.moduleName, TemplateTETile.class, IEnergyHandler.class);
        TemplateInjectionManager.registerTileTemplate(CompatibilityType.INDUSTRIALCRAFT.moduleName, TemplateICTile.class, IEnergySink.class, IEnergySource.class);
        TemplateInjectionManager.registerTileTemplate(CompatibilityType.BUILDCRAFT.moduleName, TemplateBCTile.class, IPowerReceptor.class);
        TemplateInjectionManager.registerItemTemplate(CompatibilityType.THERMAL_EXPANSION.moduleName, TemplateTEItem.class, IEnergyContainerItem.class);
        TemplateInjectionManager.registerItemTemplate(CompatibilityType.INDUSTRIALCRAFT.moduleName, TemplateICItem.class, ISpecialElectricItem.class);
        return null;
    }
}

