/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.net;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import universalelectricity.api.net.IConnector;

public class ConnectionPathfinder {
    public final Set<IConnector> closedSet = new LinkedHashSet<IConnector>();
    public final Set<IConnector> results = new LinkedHashSet<IConnector>();
    private final IConnector targetConnector;
    private final List<IConnector> ignoreConnector;

    public ConnectionPathfinder(IConnector targetConnector, IConnector ... ignoreConnector) {
        this.targetConnector = targetConnector;
        this.ignoreConnector = ignoreConnector != null ? Arrays.asList(ignoreConnector) : new ArrayList<IConnector>();
    }

    public boolean findNodes(IConnector currentNode) {
        this.closedSet.add(currentNode);
        if (this.onSearch(currentNode)) {
            return false;
        }
        for (IConnector node : this.getConnectedNodes(currentNode)) {
            if (this.closedSet.contains(node) || !this.findNodes(node)) continue;
            return true;
        }
        return false;
    }

    public Set<IConnector> getConnectedNodes(IConnector currentNode) {
        HashSet<IConnector> connectedNodes = new HashSet<IConnector>();
        if (currentNode != null) {
            for (int i = 0; i < currentNode.getConnections().length; ++i) {
                Object obj = currentNode.getConnections()[i];
                if (!(obj instanceof IConnector) || this.ignoreConnector.contains(obj)) continue;
                connectedNodes.add((IConnector)obj);
            }
        }
        return connectedNodes;
    }

    public boolean onSearch(IConnector node) {
        if (node == this.targetConnector) {
            this.results.add(node);
            return true;
        }
        return false;
    }

    public void reset() {
        this.results.clear();
        this.closedSet.clear();
    }
}

