/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.net;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import universalelectricity.api.net.INetwork;

public class NetworkTickHandler
implements ITickHandler {
    public static final NetworkTickHandler INSTANCE = new NetworkTickHandler();
    private final LinkedHashSet<INetwork> toAddNetworks = new LinkedHashSet();
    private final LinkedHashSet<INetwork> networks = new LinkedHashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addNetwork(INetwork network) {
        LinkedHashSet<INetwork> linkedHashSet = NetworkTickHandler.INSTANCE.toAddNetworks;
        synchronized (linkedHashSet) {
            if (!NetworkTickHandler.INSTANCE.networks.contains(network)) {
                NetworkTickHandler.INSTANCE.toAddNetworks.add(network);
            }
        }
    }

    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
        this.networks.addAll(this.toAddNetworks);
        this.toAddNetworks.clear();
        Iterator it = this.networks.iterator();
        while (it.hasNext()) {
            INetwork network = (INetwork)it.next();
            if (network.canUpdate()) {
                network.update();
            }
            if (network.continueUpdate()) continue;
            it.remove();
        }
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.SERVER);
    }

    public String getLabel() {
        return "Universal Electricity Grid Ticker";
    }
}

