/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.api.energy;

import net.minecraft.nbt.NBTTagCompound;

public class EnergyStorageHandler {
    protected long energy;
    protected long capacity;
    protected long maxReceive;
    protected long maxExtract;
    protected long lastEnergy;

    public EnergyStorageHandler(long capacity) {
        this(capacity, capacity, capacity);
    }

    public EnergyStorageHandler(long capacity, long maxTransfer) {
        this(capacity, maxTransfer, maxTransfer);
    }

    public EnergyStorageHandler(long capacity, long maxReceive, long maxExtract) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    public EnergyStorageHandler readFromNBT(NBTTagCompound nbt) {
        this.energy = nbt.func_74763_f("energy");
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74772_a("energy", this.energy);
        return nbt;
    }

    public void setCapacity(long capacity) {
        this.capacity = capacity;
        if (this.energy > capacity) {
            this.energy = capacity;
        }
    }

    public void setMaxTransfer(long maxTransfer) {
        this.setMaxReceive(maxTransfer);
        this.setMaxExtract(maxTransfer);
    }

    public void setMaxReceive(long maxReceive) {
        this.maxReceive = maxReceive;
    }

    public void setMaxExtract(long maxExtract) {
        this.maxExtract = maxExtract;
    }

    public long getMaxReceive() {
        return this.maxReceive;
    }

    public long getMaxExtract() {
        return this.maxExtract;
    }

    public void setEnergy(long energy) {
        this.energy = energy;
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        } else if (this.energy < 0L) {
            this.energy = 0L;
        }
    }

    public void modifyEnergyStored(long energy) {
        this.energy += energy;
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        } else if (this.energy < 0L) {
            this.energy = 0L;
        }
    }

    public long receiveEnergy(long receive, boolean doReceive) {
        long energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, receive));
        if (doReceive) {
            this.lastEnergy = this.energy;
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    public long extractEnergy(long extract, boolean doExtract) {
        long energyExtracted = Math.min(this.energy, Math.min(this.maxExtract, extract));
        if (doExtract) {
            this.lastEnergy = this.energy;
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    public boolean checkReceive(long receive) {
        return this.receiveEnergy(receive, false) >= receive;
    }

    public boolean checkExtract(long extract) {
        return this.extractEnergy(extract, false) >= extract;
    }

    public boolean isFull() {
        return this.getEnergy() >= this.getEnergyCapacity();
    }

    public long getLastEnergy() {
        return this.lastEnergy;
    }

    public boolean didEnergyStateChange() {
        return this.lastEnergy == 0L && this.energy > 0L || this.lastEnergy > 0L && this.energy == 0L;
    }

    public long getEmptySpace() {
        return this.getEnergyCapacity() - this.getEnergy();
    }

    public long getEnergy() {
        return this.energy;
    }

    public long getEnergyCapacity() {
        return this.capacity;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getEnergy() + "/" + this.getEnergyCapacity() + "]";
    }
}

