/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.api.vector;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import universalelectricity.api.vector.Vector3;

public class VectorWorld
extends Vector3 {
    public World world;

    public VectorWorld(World world, double x, double y, double z) {
        super(x, y, z);
        this.world = world;
    }

    public VectorWorld(NBTTagCompound nbt) {
        super(nbt);
        this.world = DimensionManager.getWorld((int)nbt.func_74762_e("d"));
    }

    public VectorWorld(Entity entity) {
        super(entity);
        this.world = entity.field_70170_p;
    }

    public VectorWorld(TileEntity tile) {
        super(tile);
        this.world = tile.field_70331_k;
    }

    public VectorWorld(World world, Vector3 v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.world = world;
    }

    @Override
    public VectorWorld translate(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    @Override
    public VectorWorld clone() {
        return new VectorWorld(this.world, this.x, this.y, this.z);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof VectorWorld) {
            VectorWorld vector = (VectorWorld)o;
            return this.world == vector.world && this.x == vector.x && this.y == vector.y && this.z == vector.z;
        }
        return super.equals(o);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74768_a("d", this.world.field_73011_w.field_76574_g);
        return nbt;
    }

    public int getBlockID() {
        return super.getBlockID((IBlockAccess)this.world);
    }

    public int getBlockMetadata() {
        return super.getBlockMetadata((IBlockAccess)this.world);
    }

    public TileEntity getTileEntity() {
        return super.getTileEntity((IBlockAccess)this.world);
    }

    public boolean setBlock(int id, int metadata, int notify) {
        return super.setBlock(this.world, id, metadata, notify);
    }

    public boolean setBlock(int id, int metadata) {
        return this.setBlock(id, metadata, 3);
    }

    public boolean setBlock(int id) {
        return this.setBlock(id, 0);
    }

    public List<Entity> getEntitiesWithin(Class<? extends Entity> par1Class) {
        return super.getEntitiesWithin(this.world, par1Class);
    }

    public static VectorWorld fromCenter(Entity e) {
        return new VectorWorld(e.field_70170_p, e.field_70165_t, e.field_70163_u - (double)e.field_70129_M + (double)(e.field_70131_O / 2.0f), e.field_70161_v);
    }

    public static VectorWorld fromCenter(TileEntity e) {
        return new VectorWorld(e.field_70331_k, (double)e.field_70329_l + 0.5, (double)e.field_70330_m + 0.5, (double)e.field_70327_n + 0.5);
    }
}

