/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.asm.template.tile;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import cpw.mods.fml.relauncher.ReflectionHelper;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyTile;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import universalelectricity.api.CompatibilityType;
import universalelectricity.api.electricity.IVoltageInput;
import universalelectricity.api.energy.IEnergyContainer;
import universalelectricity.api.energy.IEnergyInterface;

public class StaticTileForwarder {
    private static final HashSet<IEnergyTile> loadedIC2Tiles = new HashSet();
    public static final HashMap<IEnergyInterface, PowerHandler> powerProviderMap = new HashMap();

    public static void loadIC(IEnergyTile tile) {
        if (CompatibilityType.INDUSTRIALCRAFT.isLoaded() && !loadedIC2Tiles.contains(tile) && !((TileEntity)tile).field_70331_k.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(tile));
            loadedIC2Tiles.add(tile);
        }
    }

    public static void unloadIC(IEnergyTile tile) {
        if (CompatibilityType.INDUSTRIALCRAFT.isLoaded() && loadedIC2Tiles.contains(tile) && !((TileEntity)tile).field_70331_k.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(tile));
            loadedIC2Tiles.remove(tile);
        }
    }

    public static long onReceiveEnergy(IEnergyInterface handler, ForgeDirection from, long receive, boolean doReceive) {
        return handler.onReceiveEnergy(from, receive, doReceive);
    }

    public static long onExtractEnergy(IEnergyInterface handler, ForgeDirection from, long request, boolean doProvide) {
        return handler.onExtractEnergy(from, request, doProvide);
    }

    public static long getVoltage(IVoltageInput handler, ForgeDirection direction) {
        return handler.getVoltageInput(direction);
    }

    public static long getElectricityStored(IEnergyContainer handler, ForgeDirection from) {
        return handler.getEnergy(from);
    }

    public static long getMaxElectricity(IEnergyContainer handler, ForgeDirection from) {
        return handler.getEnergyCapacity(from);
    }

    public static boolean canConnect(IEnergyInterface handler, ForgeDirection from) {
        return handler.canConnect(from);
    }

    public static void validateTile(Object obj) {
        TileEntity tileEntity;
        if (obj instanceof TileEntity && (tileEntity = (TileEntity)obj).func_70320_p()) {
            try {
                ReflectionHelper.setPrivateValue(TileEntity.class, (Object)tileEntity, (Object)false, (String[])new String[]{"tileEntityInvalid", "field_70328_o"});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void invalidateTile(Object obj) {
        TileEntity tileEntity;
        if (obj instanceof TileEntity && !(tileEntity = (TileEntity)obj).func_70320_p()) {
            try {
                ReflectionHelper.setPrivateValue(TileEntity.class, (Object)tileEntity, (Object)true, (String[])new String[]{"tileEntityInvalid", "field_70328_o"});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static PowerHandler.PowerReceiver getPowerReceiver(IEnergyInterface handler, ForgeDirection side) {
        if (!powerProviderMap.containsKey(handler)) {
            PowerHandler powerHandler = new PowerHandler((IPowerReceptor)((Object)handler), PowerHandler.Type.MACHINE);
            if (handler instanceof IEnergyContainer) {
                float capacity = (float)((IEnergyContainer)((Object)handler)).getEnergyCapacity(ForgeDirection.UNKNOWN) * CompatibilityType.BUILDCRAFT.ratio;
                powerHandler.configure(0.0f, capacity, 1.0f, capacity);
            }
            powerHandler.configurePowerPerdition(0, 0);
            powerProviderMap.put(handler, powerHandler);
        }
        return powerProviderMap.get(handler).getPowerReceiver();
    }

    public static void doWork(IEnergyInterface handler, PowerHandler workProvider) {
        long energyToInject = (long)(workProvider.useEnergy(0.0f, workProvider.getEnergyStored(), false) * CompatibilityType.BUILDCRAFT.reciprocal_ratio);
        long energyUsed = handler.onReceiveEnergy(ForgeDirection.UNKNOWN, energyToInject, true);
        workProvider.useEnergy(0.0f, (float)energyUsed * CompatibilityType.BUILDCRAFT.ratio, true);
    }

    public static World getWorld(IEnergyInterface handler) {
        if (handler instanceof TileEntity) {
            return ((TileEntity)handler).field_70331_k;
        }
        return null;
    }
}

