/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.net;

import net.minecraftforge.common.ForgeDirection;
import universalelectricity.api.UniversalElectricity;
import universalelectricity.api.electricity.IElectricalNetwork;
import universalelectricity.api.electricity.IVoltageInput;
import universalelectricity.api.electricity.IVoltageOutput;
import universalelectricity.api.energy.IConductor;
import universalelectricity.core.net.EnergyNetwork;

public class ElectricalNetwork
extends EnergyNetwork
implements IElectricalNetwork {
    private long voltage = 0L;
    private long newVoltage = 0L;
    private long currentCapacity = 0L;

    @Override
    public void update() {
        this.newVoltage = 0L;
        super.update();
        this.voltage = this.newVoltage;
    }

    @Override
    public void reconstruct() {
        this.voltage = 0L;
        this.currentCapacity = Long.MAX_VALUE;
        super.reconstruct();
        if (this.voltage <= 0L) {
            this.voltage = UniversalElectricity.DEFAULT_VOLTAGE;
        }
    }

    @Override
    protected void reconstructConductor(IConductor conductor) {
        super.reconstructConductor(conductor);
        if (conductor.getCurrentCapacity() < this.currentCapacity) {
            this.currentCapacity = conductor.getCurrentCapacity();
        }
    }

    @Override
    protected void reconstructHandler(Object obj, ForgeDirection side) {
        if (obj instanceof IVoltageOutput && !(obj instanceof IConductor) && ((IVoltageOutput)obj).getVoltageOutput(side) > this.voltage) {
            this.voltage = ((IVoltageOutput)obj).getVoltageOutput(side);
        }
    }

    @Override
    public long addEnergyToHandler(Object handler, ForgeDirection side, long energy, boolean doPower) {
        if (handler instanceof IVoltageOutput && ((IVoltageOutput)handler).getVoltageOutput(side) > this.newVoltage) {
            this.newVoltage = ((IVoltageOutput)handler).getVoltageOutput(side);
        }
        if (handler instanceof IVoltageInput && ((IVoltageInput)handler).getVoltageInput(side) != this.getVoltage()) {
            ((IVoltageInput)handler).onWrongVoltage(side, this.voltage);
        }
        return super.addEnergyToHandler(handler, side, energy, doPower);
    }

    @Override
    public long getVoltage() {
        return this.voltage;
    }

    @Override
    public long produce(IConductor conductor, ForgeDirection from, long amount, boolean doReceive) {
        if (conductor instanceof IVoltageOutput && !(conductor instanceof IConductor)) {
            if (((IVoltageOutput)((Object)conductor)).getVoltageOutput(from) >= this.voltage) {
                return super.produce(conductor, from, amount, doReceive);
            }
            return 0L;
        }
        return super.produce(conductor, from, amount, doReceive);
    }
}

