/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.api;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;

public abstract class CompatibilityModule {
    private static final Set<CompatibilityModule> loadedModules = new LinkedHashSet<CompatibilityModule>();
    public static final HashMap<Class, CompatibilityModule> energyHandlerCache = new HashMap();
    public static final HashMap<Class, CompatibilityModule> energyStorageCache = new HashMap();

    public static void register(CompatibilityModule module) {
        loadedModules.add(module);
    }

    public static boolean canConnect(Object handler, ForgeDirection direction) {
        if (CompatibilityModule.isHandler(handler)) {
            return energyHandlerCache.get(handler.getClass()).doCanConnect(handler, direction);
        }
        return false;
    }

    public static long receiveEnergy(Object handler, ForgeDirection direction, long energy, boolean doReceive) {
        if (CompatibilityModule.isHandler(handler)) {
            return energyHandlerCache.get(handler.getClass()).doReceiveEnergy(handler, direction, energy, doReceive);
        }
        return 0L;
    }

    public static long extractEnergy(Object handler, ForgeDirection direction, long energy, boolean doReceive) {
        if (CompatibilityModule.isHandler(handler)) {
            return energyHandlerCache.get(handler.getClass()).doExtractEnergy(handler, direction, energy, doReceive);
        }
        return 0L;
    }

    public static long getEnergy(Object handler, ForgeDirection direction) {
        if (CompatibilityModule.isEnergyContainer(handler)) {
            return energyStorageCache.get(handler.getClass()).doGetEnergy(handler, direction);
        }
        return 0L;
    }

    public static long chargeItem(ItemStack itemStack, long energy, boolean doCharge) {
        if (itemStack != null && CompatibilityModule.isHandler(itemStack.func_77973_b())) {
            return energyHandlerCache.get(itemStack.func_77973_b().getClass()).doChargeItem(itemStack, energy, doCharge);
        }
        return 0L;
    }

    public static long dischargeItem(ItemStack itemStack, long energy, boolean doCharge) {
        if (itemStack != null && CompatibilityModule.isHandler(itemStack.func_77973_b())) {
            return energyHandlerCache.get(itemStack.func_77973_b().getClass()).doDischargeItem(itemStack, energy, doCharge);
        }
        return 0L;
    }

    public static ItemStack getItemWithCharge(ItemStack itemStack, long energy) {
        if (itemStack != null && CompatibilityModule.isHandler(itemStack.func_77973_b())) {
            return energyHandlerCache.get(itemStack.func_77973_b().getClass()).doGetItemWithCharge(itemStack, energy);
        }
        return null;
    }

    public static boolean isHandler(Object handler) {
        if (handler != null) {
            Class<?> clazz = handler.getClass();
            if (energyHandlerCache.containsKey(clazz)) {
                return true;
            }
            for (CompatibilityModule module : loadedModules) {
                if (!module.doIsHandler(handler)) continue;
                energyHandlerCache.put(clazz, module);
                return true;
            }
        }
        return false;
    }

    public static boolean isEnergyContainer(Object handler) {
        if (handler != null) {
            Class<?> clazz = handler.getClass();
            if (energyStorageCache.containsKey(clazz)) {
                return true;
            }
            for (CompatibilityModule module : loadedModules) {
                if (!module.doIsEnergyContainer(handler)) continue;
                energyStorageCache.put(clazz, module);
                return true;
            }
        }
        return false;
    }

    public abstract long doReceiveEnergy(Object var1, ForgeDirection var2, long var3, boolean var5);

    public abstract long doExtractEnergy(Object var1, ForgeDirection var2, long var3, boolean var5);

    public abstract long doChargeItem(ItemStack var1, long var2, boolean var4);

    public abstract long doDischargeItem(ItemStack var1, long var2, boolean var4);

    public abstract boolean doIsHandler(Object var1);

    public abstract boolean doIsEnergyContainer(Object var1);

    public abstract long doGetEnergy(Object var1, ForgeDirection var2);

    public abstract boolean doCanConnect(Object var1, ForgeDirection var2);

    public abstract ItemStack doGetItemWithCharge(ItemStack var1, long var2);
}

