/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.api;

import cpw.mods.fml.common.Loader;

public enum CompatibilityType {
    THERMAL_EXPANSION("ThermalExpansion", "ThermalExpansion", "Redstone Flux", "RF", 5628),
    INDUSTRIALCRAFT("IC2", "IndustrialCraft", "Electrical Unit", "EU", 140700),
    BUILDCRAFT("BuildCraft|Energy", "BuildCraft", "Minecraft Joule", "MJ", 56280);

    public final String modID;
    public final String moduleName;
    public final String fullUnit;
    public final String unit;
    public float ratio;
    public float reciprocal_ratio;
    public boolean isModuleEnabled;

    private CompatibilityType(String modID, String moduleName, String fullUnit, String unit, int ratio) {
        this.modID = modID;
        this.moduleName = moduleName;
        this.fullUnit = fullUnit;
        this.unit = unit;
        this.ratio = 1 / ratio;
        this.reciprocal_ratio = ratio;
    }

    public boolean isLoaded() {
        return Loader.isModLoaded((String)this.modID);
    }

    public static CompatibilityType get(String moduleName) {
        for (CompatibilityType type : CompatibilityType.values()) {
            if (!moduleName.equals(type.moduleName)) continue;
            return type;
        }
        return null;
    }
}

