/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.api.energy;

import cpw.mods.fml.common.FMLLog;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import universalelectricity.api.energy.IConductor;
import universalelectricity.api.energy.IEnergyNetwork;

public class EnergyNetworkLoader {
    public static Class<? extends IEnergyNetwork> NETWORK_CLASS;
    public static final Set<Class<? extends IEnergyNetwork>> NETWORK_CLASS_REGISTRY;

    public static void setNetworkClass(Class<? extends IEnergyNetwork> networkClass) {
        NETWORK_CLASS_REGISTRY.add(networkClass);
        NETWORK_CLASS = networkClass;
    }

    public static void setNetworkClass(String className) {
        try {
            EnergyNetworkLoader.setNetworkClass(Class.forName(className));
        }
        catch (Exception e) {
            FMLLog.severe((String)("Universal Electricity: Failed to set network class with name " + className), (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    public static IEnergyNetwork getNewNetwork(IConductor ... conductors) {
        try {
            IEnergyNetwork network = NETWORK_CLASS.newInstance();
            network.getConnectors().addAll(Arrays.asList(conductors));
            return network;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    static {
        NETWORK_CLASS_REGISTRY = new HashSet<Class<? extends IEnergyNetwork>>();
        EnergyNetworkLoader.setNetworkClass("universalelectricity.core.net.ElectricalNetwork");
    }
}

