/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.api.item;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.world.World;
import universalelectricity.api.CompatibilityModule;
import universalelectricity.api.UniversalElectricity;
import universalelectricity.api.energy.UnitDisplay;
import universalelectricity.api.item.IEnergyItem;
import universalelectricity.api.item.IVoltageItem;

public abstract class ItemElectric
extends Item
implements IEnergyItem,
IVoltageItem {
    public ItemElectric(int id) {
        super(id);
        this.func_77625_d(1);
        this.func_77656_e(100);
        this.setNoRepair();
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        String color = "";
        long joules = this.getEnergy(itemStack);
        color = joules <= this.getEnergyCapacity(itemStack) / 3L ? "\u00a74" : (joules > this.getEnergyCapacity(itemStack) * 2L / 3L ? "\u00a72" : "\u00a76");
        list.add(color + UnitDisplay.getDisplayShort(joules, UnitDisplay.Unit.JOULES) + "/" + UnitDisplay.getDisplayShort(this.getEnergyCapacity(itemStack), UnitDisplay.Unit.JOULES));
    }

    public void func_77622_d(ItemStack itemStack, World par2World, EntityPlayer par3EntityPlayer) {
        this.setEnergy(itemStack, 0L);
    }

    @Override
    public long recharge(ItemStack itemStack, long energy, boolean doReceive) {
        long energyReceived = Math.min(this.getEnergyCapacity(itemStack) - energy, Math.min(this.getTransferRate(itemStack), energy));
        if (doReceive) {
            this.setEnergy(itemStack, this.getEnergy(itemStack) + energyReceived);
        }
        return energyReceived;
    }

    public long getTransferRate(ItemStack itemStack) {
        return this.getEnergyCapacity(itemStack) / 100L;
    }

    @Override
    public long discharge(ItemStack itemStack, long energy, boolean doTransfer) {
        long energyExtracted = Math.min(energy, Math.min(this.getTransferRate(itemStack), energy));
        if (doTransfer) {
            this.setEnergy(itemStack, this.getEnergy(itemStack) - energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public long getVoltage(ItemStack itemStack) {
        return UniversalElectricity.DEFAULT_VOLTAGE;
    }

    @Override
    public void setEnergy(ItemStack itemStack, long joules) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        long electricityStored = Math.max(Math.min(joules, this.getEnergyCapacity(itemStack)), 0L);
        itemStack.func_77978_p().func_74772_a("electricity", electricityStored);
        itemStack.func_77964_b((int)(100.0 - (double)electricityStored / (double)this.getEnergyCapacity(itemStack) * 100.0));
    }

    public long getTransfer(ItemStack itemStack) {
        return this.getEnergyCapacity(itemStack) - this.getEnergy(itemStack);
    }

    @Override
    public long getEnergy(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        long energyStored = 0L;
        if (itemStack.func_77978_p().func_74764_b("electricity")) {
            NBTBase obj = itemStack.func_77978_p().func_74781_a("electricity");
            energyStored = obj instanceof NBTTagFloat ? (long)((NBTTagFloat)obj).field_74750_a : itemStack.func_77978_p().func_74763_f("electricity");
        }
        itemStack.func_77964_b((int)(100.0 - (double)energyStored / (double)this.getEnergyCapacity(itemStack) * 100.0));
        return energyStored;
    }

    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(CompatibilityModule.getItemWithCharge(new ItemStack((Item)this), 0L));
        par3List.add(CompatibilityModule.getItemWithCharge(new ItemStack((Item)this), this.getEnergyCapacity(new ItemStack((Item)this))));
    }
}

