/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.api.vector;

import universalelectricity.api.vector.Quaternion;
import universalelectricity.api.vector.Vector3;

public class Rotation {
    public double angle;
    public Vector3 axis;
    private Quaternion quat;

    public Rotation(double angle, Vector3 axis) {
        this.angle = angle;
        this.axis = axis;
    }

    public Rotation(double angle, double x, double y, double z) {
        this(angle, new Vector3(x, y, z));
    }

    public Rotation(Quaternion quat) {
        this.quat = quat;
        this.angle = Math.acos(quat.s) * 2.0;
        if (this.angle == 0.0) {
            this.axis = new Vector3(0.0, 1.0, 0.0);
        } else {
            double sa = Math.sin(this.angle * 0.5);
            this.axis = new Vector3(quat.x / sa, quat.y / sa, quat.z / sa);
        }
    }

    public void apply(Vector3 vec) {
        if (this.quat == null) {
            this.quat = Quaternion.aroundAxis(this.axis, this.angle);
        }
        vec.rotate(this.quat);
    }

    public void applyN(Vector3 normal) {
        this.apply(normal);
    }
}

