/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.asm;

import com.google.common.base.Objects;
import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import java.io.IOException;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class ObfMapping {
    public static Remapper runtimeMapper = FMLDeobfuscatingRemapper.INSTANCE;
    public static Remapper mcpMapper = null;
    public static final boolean obfuscated;
    public String s_owner;
    public String s_name;
    public String s_desc;
    public boolean runtime;

    public ObfMapping(String owner) {
        this(owner, "", "");
    }

    public ObfMapping(String owner, String name, String desc) {
        this.s_owner = owner;
        this.s_name = name;
        this.s_desc = desc;
        if (this.s_owner.contains(".")) {
            throw new IllegalArgumentException(this.s_owner);
        }
        if (mcpMapper != null) {
            this.map(mcpMapper);
        }
    }

    public ObfMapping(ObfMapping descmap, String subclass) {
        this(subclass, descmap.s_name, descmap.s_desc);
    }

    public static ObfMapping fromDesc(String s) {
        int sep;
        int lastDot = s.lastIndexOf(46);
        if (lastDot < 0) {
            return new ObfMapping(s, "", "");
        }
        int sep_end = sep = s.indexOf(40);
        if (sep < 0) {
            sep = s.indexOf(32);
            sep_end = sep + 1;
        }
        if (sep < 0) {
            sep = s.indexOf(58);
            sep_end = sep + 1;
        }
        if (sep < 0) {
            return new ObfMapping(s.substring(0, lastDot), s.substring(lastDot + 1), "");
        }
        return new ObfMapping(s.substring(0, lastDot), s.substring(lastDot + 1, sep), s.substring(sep_end));
    }

    public ObfMapping subclass(String subclass) {
        return new ObfMapping(this, subclass);
    }

    public boolean matches(MethodNode node) {
        return this.s_name.equals(node.name) && this.s_desc.equals(node.desc);
    }

    public boolean matches(MethodInsnNode node) {
        return this.s_owner.equals(node.owner) && this.s_name.equals(node.name) && this.s_desc.equals(node.desc);
    }

    public AbstractInsnNode toInsn(int opcode) {
        if (this.isClass()) {
            return new TypeInsnNode(opcode, this.s_owner);
        }
        if (this.isMethod()) {
            return new MethodInsnNode(opcode, this.s_owner, this.s_name, this.s_desc);
        }
        return new FieldInsnNode(opcode, this.s_owner, this.s_name, this.s_desc);
    }

    public void visitTypeInsn(MethodVisitor mv, int opcode) {
        mv.visitTypeInsn(opcode, this.s_owner);
    }

    public void visitMethodInsn(MethodVisitor mv, int opcode) {
        mv.visitMethodInsn(opcode, this.s_owner, this.s_name, this.s_desc);
    }

    public void visitFieldInsn(MethodVisitor mv, int opcode) {
        mv.visitFieldInsn(opcode, this.s_owner, this.s_name, this.s_desc);
    }

    public boolean isClass(String name) {
        return name.replace('.', '/').equals(this.s_owner);
    }

    public boolean matches(String name, String desc) {
        return this.s_name.equals(name) && this.s_desc.equals(desc);
    }

    public boolean matches(FieldNode node) {
        return this.s_name.equals(node.name) && this.s_desc.equals(node.desc);
    }

    public boolean matches(FieldInsnNode node) {
        return this.s_owner.equals(node.owner) && this.s_name.equals(node.name) && this.s_desc.equals(node.desc);
    }

    public String javaClass() {
        return this.s_owner.replace('/', '.');
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObfMapping)) {
            return false;
        }
        ObfMapping desc = (ObfMapping)obj;
        return this.s_owner.equals(desc.s_owner) && this.s_name.equals(desc.s_name) && this.s_desc.equals(desc.s_desc);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.s_desc, this.s_name, this.s_owner});
    }

    public String toString() {
        if (this.s_name.length() == 0) {
            return "[" + this.s_owner + "]";
        }
        if (this.s_desc.length() == 0) {
            return "[" + this.s_owner + "." + this.s_name + "]";
        }
        return "[" + (this.isMethod() ? this.methodDesc() : this.fieldDesc()) + "]";
    }

    public String methodDesc() {
        return this.s_owner + "." + this.s_name + this.s_desc;
    }

    public String fieldDesc() {
        return this.s_owner + "." + this.s_name + ":" + this.s_desc;
    }

    public boolean isClass() {
        return this.s_name.length() == 0;
    }

    public boolean isMethod() {
        return this.s_desc.contains("(");
    }

    public boolean isField() {
        return !this.isClass() && !this.isMethod();
    }

    public ObfMapping map(Remapper mapper) {
        if (this.isMethod()) {
            this.s_name = mapper.mapMethodName(this.s_owner, this.s_name, this.s_desc);
        } else if (this.isField()) {
            this.s_name = mapper.mapFieldName(this.s_owner, this.s_name, this.s_desc);
        }
        this.s_owner = mapper.mapType(this.s_owner);
        if (this.isMethod()) {
            this.s_desc = mapper.mapMethodDesc(this.s_desc);
        } else if (this.s_desc.length() > 0) {
            this.s_desc = mapper.mapDesc(this.s_desc);
        }
        return this;
    }

    public ObfMapping toRuntime() {
        if (!this.runtime) {
            this.map(runtimeMapper);
        }
        this.runtime = true;
        return this;
    }

    public ObfMapping copy() {
        return new ObfMapping(this.s_owner, this.s_name, this.s_desc);
    }

    static {
        boolean obf = true;
        try {
            obf = ((LaunchClassLoader)ObfMapping.class.getClassLoader()).getClassBytes("net.minecraft.world.World") == null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        obfuscated = obf;
    }
}

