/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.net;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import universalelectricity.api.CompatibilityModule;
import universalelectricity.api.UniversalElectricity;
import universalelectricity.api.energy.EnergyNetworkLoader;
import universalelectricity.api.energy.IConductor;
import universalelectricity.api.energy.IEnergyNetwork;
import universalelectricity.api.net.IConnector;
import universalelectricity.api.net.NetworkEvent;
import universalelectricity.core.net.ConnectionPathfinder;
import universalelectricity.core.net.Network;
import universalelectricity.core.net.NetworkTickHandler;

public class EnergyNetwork
extends Network<IEnergyNetwork, IConductor, Object>
implements IEnergyNetwork {
    protected long energyBuffer;
    protected final HashMap<IConductor, Long> conductorBuffer = new HashMap();
    protected float resistance;
    protected long lastEnergyBuffer;
    protected long lastNetworkRequest = -1L;
    protected final HashMap<Object, EnumSet<ForgeDirection>> handlerDirectionMap = new LinkedHashMap<Object, EnumSet<ForgeDirection>>();

    @Override
    public void addConnector(IConductor connector) {
        connector.setNetwork(this);
        this.conductorBuffer.put(connector, 0L);
        super.addConnector(connector);
    }

    @Override
    public void update() {
        long usableEnergy;
        long currentEnergy = usableEnergy = this.energyBuffer - this.getEnergyLoss();
        long perHandler = 0L;
        long perSide = 0L;
        int handlers = this.handlerDirectionMap.size();
        if (handlers > 0) {
            for (Map.Entry<Object, EnumSet<ForgeDirection>> entry : this.handlerDirectionMap.entrySet()) {
                perHandler = usableEnergy / (long)handlers + usableEnergy % (long)handlers;
                for (ForgeDirection direction : entry.getValue()) {
                    perSide = perHandler / (long)entry.getValue().size() + perHandler % (long)entry.getValue().size();
                    currentEnergy -= this.addEnergyToHandler(entry.getKey(), direction, perSide, true);
                }
                if (handlers <= 1) continue;
                --handlers;
            }
            if (usableEnergy != currentEnergy) {
                this.energyBuffer = Math.max(currentEnergy, 0L);
            }
        }
        long remainingBufferPerConductor = this.energyBuffer / (long)this.getConnectors().size();
        Iterator it = this.getConnectors().iterator();
        while (it.hasNext()) {
            this.conductorBuffer.put((IConductor)it.next(), remainingBufferPerConductor);
        }
        this.lastNetworkRequest = -1L;
    }

    public long addEnergyToHandler(Object handler, ForgeDirection side, long energy, boolean doApply) {
        return CompatibilityModule.receiveEnergy(handler, side, energy, doApply);
    }

    @Override
    public boolean canUpdate() {
        return this.getConnectors().size() > 0 && this.getNodes().size() > 0 && this.energyBuffer > 0L;
    }

    @Override
    public boolean continueUpdate() {
        return this.canUpdate();
    }

    @Override
    public long getRequest() {
        if (this.lastNetworkRequest == -1L) {
            this.lastNetworkRequest = 0L;
            if (this.getNodes().size() > 0) {
                for (Map.Entry<Object, EnumSet<ForgeDirection>> entry : this.handlerDirectionMap.entrySet()) {
                    if (entry.getValue() == null || entry.getValue() instanceof IConductor) continue;
                    for (ForgeDirection direction : entry.getValue()) {
                        this.lastNetworkRequest += Math.max(CompatibilityModule.receiveEnergy(entry.getKey(), direction, Long.MAX_VALUE, false), 0L);
                    }
                }
            }
        }
        return this.lastNetworkRequest;
    }

    @Override
    public float getResistance() {
        return this.resistance;
    }

    @Override
    public void reconstruct() {
        if (this.getConnectors().size() > 0) {
            this.getNodes().clear();
            this.handlerDirectionMap.clear();
            this.resistance = 0.0f;
            Iterator it = this.getConnectors().iterator();
            while (it.hasNext()) {
                IConductor conductor = (IConductor)it.next();
                if (conductor != null) {
                    this.reconstructConductor(conductor);
                    continue;
                }
                it.remove();
            }
            if (this.getNodes().size() > 0) {
                NetworkTickHandler.addNetwork(this);
            }
        }
    }

    protected void reconstructConductor(IConductor conductor) {
        conductor.setNetwork(this);
        for (int i = 0; i < conductor.getConnections().length; ++i) {
            this.reconstructHandler(conductor.getConnections()[i], ForgeDirection.getOrientation((int)i).getOpposite());
        }
        this.resistance += conductor.getResistance();
    }

    protected void reconstructHandler(Object obj, ForgeDirection side) {
        if (obj != null && !(obj instanceof IConductor) && CompatibilityModule.canConnect(obj, side)) {
            EnumSet<ForgeDirection> set = this.handlerDirectionMap.get(obj);
            if (set == null) {
                set = EnumSet.noneOf(ForgeDirection.class);
            }
            this.getNodes().add(obj);
            set.add(side);
            this.handlerDirectionMap.put(obj, set);
        }
    }

    @Override
    public IEnergyNetwork merge(IEnergyNetwork network) {
        if (network instanceof EnergyNetwork && network != this) {
            long newBuffer = this.getBuffer();
            newBuffer += ((EnergyNetwork)network).getBuffer();
            EnergyNetwork newNetwork = new EnergyNetwork();
            newNetwork.getConnectors().addAll(this.getConnectors());
            newNetwork.getConnectors().addAll(network.getConnectors());
            network.getConnectors().clear();
            network.getNodes().clear();
            this.getConnectors().clear();
            this.getNodes().clear();
            newNetwork.reconstruct();
            newNetwork.setBuffer(newBuffer);
            return newNetwork;
        }
        return null;
    }

    @Override
    public void split(IConductor splitPoint) {
        this.removeConnector(splitPoint);
        this.reconstruct();
        long energyPerWire = this.energyBuffer / (long)Math.max(this.getConnectors().size(), 1);
        Object[] connectedBlocks = splitPoint.getConnections();
        for (int i = 0; i < connectedBlocks.length; ++i) {
            Object connectedBlockA = connectedBlocks[i];
            if (!(connectedBlockA instanceof IConnector)) continue;
            for (int ii = 0; ii < connectedBlocks.length; ++ii) {
                Object connectedBlockB = connectedBlocks[ii];
                if (connectedBlockA == connectedBlockB || !(connectedBlockB instanceof IConnector)) continue;
                ConnectionPathfinder finder = new ConnectionPathfinder((IConnector)connectedBlockB, splitPoint);
                finder.findNodes((IConnector)connectedBlockA);
                if (finder.results.size() > 0) continue;
                try {
                    EnergyNetwork newNetwork = new EnergyNetwork();
                    for (IConnector node : finder.closedSet) {
                        if (node == splitPoint || !(node instanceof IConductor)) continue;
                        newNetwork.addConnector((IConductor)node);
                        this.removeConnector((IConductor)node);
                        newNetwork.energyBuffer += energyPerWire;
                        this.energyBuffer -= energyPerWire;
                    }
                    newNetwork.reconstruct();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void split(IConductor connectorA, IConductor connectorB) {
        this.reconstruct();
        ConnectionPathfinder finder = new ConnectionPathfinder(connectorB, new IConnector[0]);
        finder.findNodes(connectorA);
        if (finder.results.size() <= 0) {
            IEnergyNetwork newNetwork = EnergyNetworkLoader.getNewNetwork(new IConductor[0]);
            for (IConnector node : finder.closedSet) {
                if (!(node instanceof IConductor)) continue;
                newNetwork.addConnector((IConductor)node);
            }
            newNetwork.reconstruct();
        }
    }

    @Override
    public long produce(IConductor conductor, ForgeDirection from, long amount, boolean doReceive) {
        NetworkEvent.EnergyProduceEvent evt = new NetworkEvent.EnergyProduceEvent(this, conductor, amount, doReceive);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        if (!evt.isCanceled() && amount > 0L) {
            long conductorBuffer = 0L;
            if (this.conductorBuffer.containsKey(conductor)) {
                conductorBuffer = this.conductorBuffer.get(conductor);
            }
            long energyReceived = Math.min(conductor.getCurrentCapacity() * UniversalElectricity.DEFAULT_VOLTAGE - conductorBuffer, amount);
            if (doReceive && energyReceived > 0L) {
                this.energyBuffer += energyReceived;
                this.conductorBuffer.put(conductor, conductorBuffer += energyReceived);
                NetworkTickHandler.addNetwork(this);
            }
            return Math.max(energyReceived, 0L);
        }
        return 0L;
    }

    protected long getEnergyLoss() {
        long amperage = this.getBuffer() / this.getVoltage();
        return (long)((float)(amperage * amperage) * this.resistance);
    }

    public long getVoltage() {
        return UniversalElectricity.DEFAULT_VOLTAGE;
    }

    public long getBuffer() {
        return this.energyBuffer;
    }

    public void setBuffer(long newBuffer) {
        this.energyBuffer = newBuffer;
    }

    @Override
    public long getLastBuffer() {
        return this.lastEnergyBuffer;
    }

    @Override
    public long getBufferOf(IConductor conductor) {
        if (this.conductorBuffer != null && this.conductorBuffer.containsKey(conductor) && this.conductorBuffer.get(conductor) != null) {
            return this.conductorBuffer.get(conductor);
        }
        return 0L;
    }

    @Override
    public void setBufferFor(IConductor conductor, long buffer) {
        this.conductorBuffer.put(conductor, buffer);
    }
}

