/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.config;

import codechicken.core.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.ClientHandler;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.config.Option;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.lwjgl.opengl.GL11;

public abstract class DataDumper
extends Option {
    public DataDumper(String name) {
        super(name);
    }

    public abstract String[] header();

    public abstract Iterable<String[]> dump(int var1);

    public String renderName() {
        return this.translateN(this.name + "s", new Object[0]);
    }

    public void dumpFile() {
        try {
            File file = new File(atv.w().x, "dumps/" + this.getFileName(this.name.replaceFirst(".+\\.", "")));
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            this.dumpTo(file);
            NEIClientUtils.addChatMessage(this.dumpMessage(file));
        }
        catch (Exception e) {
            System.err.println("Error dumping " + this.renderName() + " mode: " + this.getMode());
            e.printStackTrace();
        }
    }

    public String getFileName(String suffix) {
        return suffix + ".csv";
    }

    public String dumpMessage(File file) {
        return ClientHandler.lang.translate("options.tools.dump.dumped", new Object[]{this.translateN(this.name, new Object[0]), "dumps/" + file.getName()});
    }

    public void dumpTo(File file) throws IOException {
        int mode = this.getMode();
        PrintWriter w = new PrintWriter(file);
        w.println(DataDumper.concat(this.header()));
        for (String[] line : this.dump(mode)) {
            w.println(DataDumper.concat(line));
        }
        w.close();
    }

    public static String concat(String[] header) {
        StringBuffer sb2 = new StringBuffer();
        for (String s : header) {
            if (sb2.length() > 0) {
                sb2.append(',');
            }
            if (s == null) {
                s = "null";
            }
            if (s.indexOf(44) > 0 || s.indexOf(34) > 0) {
                s = '\"' + s.replace("\"", "\"\"") + '\"';
            }
            sb2.append(s);
        }
        return sb2.toString();
    }

    @Override
    public void draw(int mousex, int mousey, float frame) {
        this.drawPrefix();
        this.drawModeButton(mousex, mousey);
        this.drawDumpButton(mousex, mousey);
    }

    public void drawPrefix() {
        GuiDraw.drawString((String)this.renderName(), (int)10, (int)8, (int)-1);
    }

    public Rectangle4i dumpButtonSize() {
        int width = 80;
        return new Rectangle4i(this.slot.contentWidth() - width, 2, width, 20);
    }

    public Rectangle4i modeButtonSize() {
        int width = 60;
        return new Rectangle4i(this.slot.contentWidth() - width - 10 - this.dumpButtonSize().w, 2, width, 20);
    }

    public String dumpButtonText() {
        return ClientHandler.lang.translate("options.tools.dump.dump", new Object[0]);
    }

    public String modeButtonText() {
        return ClientHandler.lang.translate("options.tools.dump.mode." + this.getMode(), new Object[0]);
    }

    public int getMode() {
        return this.getTag().getIntValue(0);
    }

    public void drawModeButton(int mousex, int mousey) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Rectangle4i b = this.modeButtonSize();
        boolean hover = b.contains(mousex, mousey);
        LayoutManager.drawButtonBackground(b.x, b.y, b.w, b.h, true, this.getButtonTex(hover));
        GuiDraw.drawStringC((String)this.modeButtonText(), (int)b.x, (int)b.y, (int)b.w, (int)b.h, (int)this.getTextColour(hover));
    }

    public void drawDumpButton(int mousex, int mousey) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Rectangle4i b = this.dumpButtonSize();
        boolean hover = b.contains(mousex, mousey);
        LayoutManager.drawButtonBackground(b.x, b.y, b.w, b.h, true, this.getButtonTex(hover));
        GuiDraw.drawStringC((String)this.dumpButtonText(), (int)b.x, (int)b.y, (int)b.w, (int)b.h, (int)this.getTextColour(hover));
    }

    public int getButtonTex(boolean hover) {
        return hover ? 2 : 1;
    }

    public int getTextColour(boolean hover) {
        return hover ? -96 : -2039584;
    }

    @Override
    public void mouseClicked(int mousex, int mousey, int button) {
        if (this.modeButtonSize().contains(mousex, mousey)) {
            atv.w().v.a("random.click", 1.0f, 1.0f);
            this.getTag().setIntValue((this.getMode() + 1) % this.modeCount());
        } else if (this.dumpButtonSize().contains(mousex, mousey)) {
            atv.w().v.a("random.click", 1.0f, 1.0f);
            this.dumpFile();
        }
    }

    public int modeCount() {
        return 3;
    }
}

