/*
 * Decompiled with CFR 0.152.
 */
package com.nuclearw.acidrain.listeners;

import com.nuclearw.acidrain.AcidRain;
import com.nuclearw.acidrain.Config;
import java.util.List;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.weather.WeatherChangeEvent;

public class WeatherListener
implements Listener {
    private AcidRain plugin;
    private final Random rand = new Random();

    public WeatherListener(AcidRain plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void weatherevent(WeatherChangeEvent event) {
        if (event.toWeatherState()) {
            if (Config.rainWarning) {
                World world = event.getWorld();
                if (this.rand.nextInt(100) >= Config.acidRainChance) {
                    return;
                }
                this.plugin.raining.add(world);
                List players = world.getPlayers();
                for (Player player : players) {
                    if (player.hasPermission("acidrain.immune")) {
                        return;
                    }
                    String formatedmsg = Config.rainWarningMsg;
                    formatedmsg = ChatColor.translateAlternateColorCodes((char)'&', (String)formatedmsg);
                    player.sendMessage(formatedmsg);
                }
            }
        } else if (this.plugin.raining.contains(event.getWorld())) {
            this.plugin.raining.remove(event.getWorld());
        }
    }
}

