/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen;

import CustomOreGen.Client.ClientState;
import CustomOreGen.CustomOreGenBase;
import CustomOreGen.ForgeInterface;
import CustomOreGen.Server.ServerState;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiSelectWorld;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

@Mod(modid="CustomOreGenRevived", name="Custom Ore Generation: First Revival", version="1.0.24", acceptedMinecraftVersions="[1.6.4]", dependencies="after:*;")
public class FMLInterface
implements ITickHandler,
IWorldGenerator {
    @Mod.Instance(value="CustomOreGen")
    public static FMLInterface instance;
    private Object _worldCreationGui = null;
    private long _serverTickCount = 0L;

    @Mod.EventHandler
    public void onFMLPreInit(FMLPreInitializationEvent event) {
        CustomOreGenBase.log = event.getModLog();
        CustomOreGenBase.log.finer("Registering FML interface ...");
        TickRegistry.registerTickHandler((ITickHandler)this, (Side)FMLCommonHandler.instance().getSide());
        GameRegistry.registerWorldGenerator((IWorldGenerator)this);
        if (CustomOreGenBase.hasForge()) {
            ForgeInterface.createAndRegister();
        }
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        ServerState.checkIfServerChanged(MinecraftServer.func_71276_C(), null);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        ServerState.checkIfServerChanged(MinecraftServer.func_71276_C(), world.func_72912_H());
        ServerState.onPopulateChunk(world, random, chunkX, chunkZ);
    }

    public void tickStart(EnumSet type, Object ... tickData) {
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
        if (type.contains(TickType.SERVER)) {
            this.onServerTick();
        }
        if (type.contains(TickType.CLIENT)) {
            this.onClientTick();
        }
    }

    private void onServerTick() {
        ServerState.checkIfServerChanged(MinecraftServer.func_71276_C(), null);
        ++this._serverTickCount;
    }

    @SideOnly(value=Side.CLIENT)
    private void onClientTick() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null && mc.field_71462_r != null) {
            if (mc.field_71462_r instanceof GuiCreateWorld) {
                if (this._worldCreationGui == null) {
                    this._worldCreationGui = mc.field_71462_r;
                }
                ServerState.onWorldCreationMenuTick((GuiCreateWorld)mc.field_71462_r);
            } else if (this._worldCreationGui != null && (mc.field_71462_r instanceof GuiSelectWorld || mc.field_71462_r instanceof GuiMainMenu)) {
                this._worldCreationGui = null;
                ServerState.onWorldCreationMenuTick(null);
            }
        } else if (this._worldCreationGui != null) {
            this._worldCreationGui = null;
            ServerState.onWorldCreationMenuTick(null);
        }
        if (mc.func_71356_B()) {
            this.onServerTick();
        }
        if (mc.field_71441_e != null && ClientState.hasWorldChanged((World)mc.field_71441_e)) {
            ClientState.onWorldChanged((World)mc.field_71441_e);
        }
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.CLIENT, TickType.SERVER);
    }

    public String getLabel() {
        return "CustomOreGen.FMLInterface";
    }
}

